/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types.pb;

import com.google.protobuf.Descriptors;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.pb.EnumValueDescription;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.pb.PbTypeDescription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FileDescription {
    private final Map<String, PbTypeDescription> types;
    private final Map<String, EnumValueDescription> enums;

    private FileDescription(Map<String, PbTypeDescription> types, Map<String, EnumValueDescription> enums) {
        this.types = types;
        this.enums = enums;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileDescription that = (FileDescription)o;
        return Objects.equals(this.types, that.types) && Objects.equals(this.enums, that.enums);
    }

    public int hashCode() {
        return Objects.hash(this.types, this.enums);
    }

    public static FileDescription newFileDescription(Descriptors.FileDescriptor fileDesc) {
        FileMetadata metadata = FileMetadata.collectFileMetadata(fileDesc);
        HashMap<String, EnumValueDescription> enums = new HashMap<String, EnumValueDescription>();
        metadata.enumValues.forEach((name, enumVal) -> enums.put((String)name, EnumValueDescription.newEnumValueDescription(name, enumVal)));
        HashMap<String, PbTypeDescription> types = new HashMap<String, PbTypeDescription>();
        metadata.msgTypes.forEach((name, msgType) -> types.put((String)name, PbTypeDescription.newTypeDescription(name, msgType)));
        return new FileDescription(types, enums);
    }

    public EnumValueDescription getEnumDescription(String enumName) {
        return this.enums.get(FileDescription.sanitizeProtoName(enumName));
    }

    public String[] getEnumNames() {
        return this.enums.keySet().toArray(new String[0]);
    }

    public PbTypeDescription getTypeDescription(String typeName) {
        return this.types.get(FileDescription.sanitizeProtoName(typeName));
    }

    public String[] getTypeNames() {
        return this.types.keySet().toArray(new String[0]);
    }

    static String sanitizeProtoName(String name) {
        if (name != null && !name.isEmpty() && name.charAt(0) == '.') {
            return name.substring(1);
        }
        return name;
    }

    static final class FileMetadata {
        final Map<String, Descriptors.Descriptor> msgTypes;
        final Map<String, Descriptors.EnumValueDescriptor> enumValues;

        private FileMetadata(Map<String, Descriptors.Descriptor> msgTypes, Map<String, Descriptors.EnumValueDescriptor> enumValues) {
            this.msgTypes = msgTypes;
            this.enumValues = enumValues;
        }

        static FileMetadata collectFileMetadata(Descriptors.FileDescriptor fileDesc) {
            HashMap<String, Descriptors.Descriptor> msgTypes = new HashMap<String, Descriptors.Descriptor>();
            HashMap<String, Descriptors.EnumValueDescriptor> enumValues = new HashMap<String, Descriptors.EnumValueDescriptor>();
            FileMetadata.collectMsgTypes(fileDesc.getMessageTypes(), msgTypes, enumValues);
            FileMetadata.collectEnumValues(fileDesc.getEnumTypes(), enumValues);
            return new FileMetadata(msgTypes, enumValues);
        }

        private static void collectMsgTypes(List<Descriptors.Descriptor> msgTypes, Map<String, Descriptors.Descriptor> msgTypeMap, Map<String, Descriptors.EnumValueDescriptor> enumValueMap) {
            for (Descriptors.Descriptor msgType : msgTypes) {
                List<Descriptors.EnumDescriptor> nestedEnumTypes;
                msgTypeMap.put(msgType.getFullName(), msgType);
                List<Descriptors.Descriptor> nestedMsgTypes = msgType.getNestedTypes();
                if (!nestedMsgTypes.isEmpty()) {
                    FileMetadata.collectMsgTypes(nestedMsgTypes, msgTypeMap, enumValueMap);
                }
                if ((nestedEnumTypes = msgType.getEnumTypes()).isEmpty()) continue;
                FileMetadata.collectEnumValues(nestedEnumTypes, enumValueMap);
            }
        }

        private static void collectEnumValues(List<Descriptors.EnumDescriptor> enumTypes, Map<String, Descriptors.EnumValueDescriptor> enumValueMap) {
            for (Descriptors.EnumDescriptor enumType : enumTypes) {
                List<Descriptors.EnumValueDescriptor> enumTypeValues = enumType.getValues();
                for (Descriptors.EnumValueDescriptor enumValue : enumTypeValues) {
                    String enumValueName = String.format("%s.%s", enumType.getFullName(), enumValue.getName());
                    enumValueMap.put(enumValueName, enumValue);
                }
            }
        }
    }
}

