/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.StringT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Types;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Type;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeEnum;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Trait;
import java.util.Collections;
import java.util.EnumSet;

public class TypeT
implements Type,
Val {
    public static final Type TypeType = TypeT.newTypeValue(TypeEnum.Type, new Trait[0]);
    private final TypeEnum typeEnum;
    private final EnumSet<Trait> traitMask;

    TypeT(TypeEnum typeEnum, Trait ... traits) {
        EnumSet<Trait> traitEnumSet = EnumSet.noneOf(Trait.class);
        Collections.addAll(traitEnumSet, traits);
        this.typeEnum = typeEnum;
        this.traitMask = traitEnumSet;
    }

    static Type newTypeValue(TypeEnum typeEnum, Trait ... traits) {
        return new TypeT(typeEnum, traits);
    }

    public static Type newObjectTypeValue(String name) {
        return new ObjectTypeT(name);
    }

    @Override
    public boolean booleanValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long intValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        throw new UnsupportedOperationException("type conversion not supported for 'type'");
    }

    @Override
    public Val convertToType(Type typeVal) {
        switch (typeVal.typeEnum()) {
            case Type: {
                return TypeType;
            }
            case String: {
                return StringT.stringOf(this.typeName());
            }
        }
        return Err.newTypeConversionError(TypeType, typeVal);
    }

    @Override
    public Val equal(Val other) {
        if (TypeType != other.type()) {
            return Err.noSuchOverload(this, "equal", other);
        }
        return Types.boolOf(this.equals(other));
    }

    @Override
    public boolean hasTrait(Trait trait) {
        return this.traitMask.contains((Object)trait);
    }

    @Override
    public TypeEnum typeEnum() {
        return this.typeEnum;
    }

    public String toString() {
        return this.typeName();
    }

    @Override
    public Type type() {
        return TypeType;
    }

    @Override
    public String typeName() {
        return this.typeEnum.getName();
    }

    @Override
    public Object value() {
        return this.typeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type typeValue = (Type)o;
        return this.typeEnum == typeValue.typeEnum() && this.typeName().equals(typeValue.typeName());
    }

    public int hashCode() {
        return this.typeName().hashCode();
    }

    static final class ObjectTypeT
    extends TypeT {
        private final String typeName;

        ObjectTypeT(String typeName) {
            super(TypeEnum.Object, Trait.FieldTesterType, Trait.IndexerType);
            this.typeName = typeName;
        }

        @Override
        public String typeName() {
            return this.typeName;
        }
    }
}

