/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.NullValue;
import com.google.protobuf.Value;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.BoolT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.StringT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.TypeT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.BaseVal;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Type;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeEnum;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Trait;

public final class NullT
extends BaseVal {
    public static final Type NullType = TypeT.newTypeValue(TypeEnum.Null, new Trait[0]);
    public static final NullT NullValue = new NullT();
    private static final Value PbValue = Value.newBuilder().setNullValue(com.google.protobuf.NullValue.NULL_VALUE).build();
    private static final Any PbAny = Any.pack(PbValue);

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == Integer.class || typeDesc == Integer.TYPE) {
            return (T)Integer.valueOf(0);
        }
        if (typeDesc == Any.class) {
            return (T)PbAny;
        }
        if (typeDesc == Value.class) {
            return (T)PbValue;
        }
        if (typeDesc == NullValue.class) {
            return (T)com.google.protobuf.NullValue.NULL_VALUE;
        }
        if (typeDesc == Val.class || typeDesc == NullT.class) {
            return (T)this;
        }
        if (typeDesc == Object.class) {
            return null;
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", NullType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case String: {
                return StringT.stringOf("null");
            }
            case Null: {
                return this;
            }
            case Type: {
                return NullType;
            }
        }
        return Err.newTypeConversionError(NullType, typeValue);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Null: {
                return BoolT.True;
            }
            case String: 
            case Int: 
            case Uint: 
            case Double: 
            case Bytes: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Type type() {
        return NullType;
    }

    @Override
    public Object value() {
        return com.google.protobuf.NullValue.NULL_VALUE;
    }

    @Override
    public String toString() {
        return "null";
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj.getClass() == NullT.class;
    }
}

