/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Types;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.BaseVal;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Type;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeAdapter;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface IteratorT
extends Val {
    public static IteratorT javaIterator(TypeAdapter adapter, Iterator<?> iterator) {
        return new JavaIteratorT(adapter, iterator);
    }

    public Val hasNext();

    public Val next();

    public static final class JavaIteratorT
    extends BaseVal
    implements IteratorT {
        private final TypeAdapter adapter;
        private final Iterator<?> iterator;

        JavaIteratorT(TypeAdapter adapter, Iterator<?> iterator) {
            this.adapter = adapter;
            this.iterator = iterator;
        }

        @Override
        public Val hasNext() {
            return Types.boolOf(this.iterator.hasNext());
        }

        @Override
        public Val next() {
            Object n;
            try {
                n = this.iterator.next();
            }
            catch (NoSuchElementException e) {
                return Err.noMoreElements();
            }
            if (n instanceof Val) {
                return (Val)n;
            }
            return this.adapter.nativeToValue(n);
        }

        @Override
        public <T> T convertToNative(Class<T> typeDesc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Val convertToType(Type typeValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Val equal(Val other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }
    }
}

