/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.TypeT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.UnknownT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.BaseVal;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Type;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeEnum;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Trait;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class Err
extends BaseVal {
    public static final Type ErrType = TypeT.newTypeValue(TypeEnum.Err, new Trait[0]);
    public static final Val errIntOverflow = Err.newErr("integer overflow", new Object[0]);
    public static final Val errUintOverflow = Err.newErr("unsigned integer overflow", new Object[0]);
    public static final Val errDurationOverflow = Err.newErr("duration overflow", new Object[0]);
    public static final Val errDurationOutOfRange = Err.newErr("duration out of range", new Object[0]);
    public static final Val errTimestampOverflow = Err.newErr("timestamp overflow", new Object[0]);
    public static final Val errTimestampOutOfRange = Err.newErr("timestamp out of range", new Object[0]);
    private final String error;
    private final Throwable cause;

    private Err(String error) {
        this(error, null);
    }

    private Err(String error, Throwable cause) {
        this.error = error;
        this.cause = cause;
    }

    public static Val noSuchOverload(Val val, String function, Val other) {
        String otName;
        String string = other != null ? (other instanceof Type ? (Type)other : other.type()).typeName() : (otName = "*");
        if (val != null) {
            Type vt = val instanceof Type ? (Type)val : val.type();
            return Err.valOrErr(other, "no such overload: %s.%s(%s)", vt.typeName(), function, otName);
        }
        return Err.valOrErr(other, "no such overload: *.%s(%s)", function, otName);
    }

    public static Val noSuchOverload(Val val, String function, Type argA, Type argB) {
        return Err.newErr("no such overload: %s.%s(%s,%s,...)", val.type().typeName(), function, argA, argB);
    }

    public static Val noSuchOverload(Val val, String function, String overload, Val[] args) {
        return Err.newErr("no such overload: %s.%s[%s](%s)", val.type().typeName(), function, overload, Arrays.stream(args).map(a -> a.type().typeName()).collect(Collectors.joining(", ")));
    }

    public static Val maybeNoSuchOverloadErr(Val val) {
        return Err.valOrErr(val, "no such overload", new Object[0]);
    }

    public static Val newErr(String format, Object ... args) {
        return new Err(String.format(format, args));
    }

    public static Val newErr(Throwable cause, String format, Object ... args) {
        if (cause instanceof ErrException) {
            return ((ErrException)cause).getErr();
        }
        return new Err(String.format(format, args), cause);
    }

    public static Val unsupportedRefValConversionErr(Object val) {
        return Err.newErr("unsupported conversion to ref.Val: (%s)%s", val.getClass().getSimpleName(), val);
    }

    public static Val valOrErr(Val val, String format, Object ... args) {
        if (val == null) {
            return Err.newErr(format, args);
        }
        if (val.type() == ErrType || val.type() == UnknownT.UnknownType) {
            return val;
        }
        return Err.newErr(format, args);
    }

    public static Val noSuchField(Object field) {
        return Err.newErr("no such field '%s'", field);
    }

    public static Val unknownType(Object field) {
        return Err.newErr("unknown type '%s'", field);
    }

    public static Val anyWithEmptyType() {
        return Err.newErr("conversion error: got Any with empty type-url", new Object[0]);
    }

    public static Val divideByZero() {
        return Err.newErr("divide by zero", new Object[0]);
    }

    public static Val noMoreElements() {
        return Err.newErr("no more elements", new Object[0]);
    }

    public static Val modulusByZero() {
        return Err.newErr("modulus by zero", new Object[0]);
    }

    public static Val rangeError(Object from, Object to) {
        return Err.newErr("range error converting %s to %s", from, to);
    }

    public static Val newTypeConversionError(Object from, Object to) {
        return Err.newErr("type conversion error from '%s' to '%s'", from, to);
    }

    public static RuntimeException noSuchAttributeException(Object context) {
        return new ErrException("undeclared reference to '%s' (in container '')", context);
    }

    public static Val noSuchKey(Object key) {
        return Err.newErr("no such key: %s", key);
    }

    public static RuntimeException noSuchKeyException(Object key) {
        return new ErrException("no such key: %s", key);
    }

    public static RuntimeException indexOutOfBoundsException(Object i) {
        return new IllegalStateException(String.format("index out of bounds: %s", i));
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        throw new UnsupportedOperationException(this.error);
    }

    @Override
    public Val convertToType(Type typeVal) {
        return this;
    }

    @Override
    public Val equal(Val other) {
        return this;
    }

    @Override
    public String toString() {
        return this.error;
    }

    @Override
    public Type type() {
        return ErrType;
    }

    @Override
    public Object value() {
        return this.error;
    }

    @Override
    public boolean booleanValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long intValue() {
        throw new UnsupportedOperationException();
    }

    public static boolean isError(Val val) {
        return val != null && val.type() == ErrType;
    }

    public boolean hasCause() {
        return this.cause != null;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public RuntimeException toRuntimeException() {
        if (this.cause != null) {
            throw new RuntimeException(this.error, this.cause);
        }
        throw new RuntimeException(this.error);
    }

    public static void throwErrorAsIllegalStateException(Val val) {
        if (val instanceof Err) {
            Err e = (Err)val;
            if (e.cause != null) {
                throw new IllegalStateException(e.error, e.cause);
            }
            throw new IllegalStateException(e.error);
        }
    }

    public static final class ErrException
    extends IllegalArgumentException {
        private final String format;
        private final Object[] args;

        public ErrException(String format, Object ... args) {
            super(String.format(format, args));
            this.format = format;
            this.args = args;
        }

        public Val getErr() {
            return Err.newErr(this.format, this.args);
        }
    }
}

