/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types;

import com.google.api.expr.v1alpha1.Constant;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Value;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.debug.Debug;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.BoolT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IntT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.StringT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.TypeT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Types;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.BaseVal;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Type;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeEnum;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Adder;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Comparer;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Sizer;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Trait;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Unescape;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public final class BytesT
extends BaseVal
implements Adder,
Comparer,
Sizer {
    public static final Type BytesType = TypeT.newTypeValue(TypeEnum.Bytes, Trait.AdderType, Trait.ComparerType, Trait.SizerType);
    private final byte[] b;

    public static BytesT bytesOf(byte[] b) {
        return new BytesT(b);
    }

    public static Val bytesOf(ByteString value) {
        return BytesT.bytesOf(value.toByteArray());
    }

    public static BytesT bytesOf(String s) {
        return new BytesT(s.getBytes(StandardCharsets.UTF_8));
    }

    private BytesT(byte[] b) {
        this.b = b;
    }

    @Override
    public Val add(Val other) {
        if (!(other instanceof BytesT)) {
            return Err.noSuchOverload(this, "add", other);
        }
        byte[] o = ((BytesT)other).b;
        byte[] n = Arrays.copyOf(this.b, this.b.length + o.length);
        System.arraycopy(o, 0, n, this.b.length, o.length);
        return BytesT.bytesOf(n);
    }

    @Override
    public Val compare(Val other) {
        if (!(other instanceof BytesT)) {
            return Err.noSuchOverload(this, "compare", other);
        }
        byte[] o = ((BytesT)other).b;
        int l = this.b.length;
        int ol = o.length;
        int cl = Math.min(l, ol);
        for (int i = 0; i < cl; ++i) {
            byte b1 = this.b[i];
            byte b2 = o[i];
            int cmpUns = Byte.toUnsignedInt(b1) - Byte.toUnsignedInt(b2);
            if (cmpUns == 0) continue;
            return IntT.intOfCompare(cmpUns);
        }
        return IntT.intOfCompare(l - ol);
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == ByteString.class || typeDesc == Object.class) {
            return (T)ByteString.copyFrom(this.b);
        }
        if (typeDesc == byte[].class) {
            return (T)this.b;
        }
        if (typeDesc == String.class) {
            try {
                return (T)Unescape.toUtf8(ByteBuffer.wrap(this.b));
            }
            catch (Exception e) {
                throw new RuntimeException("invalid UTF-8 in bytes, cannot convert to string");
            }
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(BytesValue.of(ByteString.copyFrom(this.b)));
        }
        if (typeDesc == BytesValue.class) {
            return (T)BytesValue.of(ByteString.copyFrom(this.b));
        }
        if (typeDesc == ByteBuffer.class) {
            return (T)ByteBuffer.wrap(this.b);
        }
        if (typeDesc == Val.class || typeDesc == BytesT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            return (T)Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(this.b)).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", BytesType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case String: {
                try {
                    return StringT.stringOf(Unescape.toUtf8(ByteBuffer.wrap(this.b)));
                }
                catch (Exception e) {
                    return Err.newErr(e, "invalid UTF-8 in bytes, cannot convert to string", new Object[0]);
                }
            }
            case Bytes: {
                return this;
            }
            case Type: {
                return BytesType;
            }
        }
        return Err.newTypeConversionError(BytesType, typeValue);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Bytes: {
                return Types.boolOf(Arrays.equals(this.b, ((BytesT)other).b));
            }
            case Null: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val size() {
        return IntT.intOf(this.b.length);
    }

    @Override
    public Type type() {
        return BytesType;
    }

    @Override
    public Object value() {
        return this.b;
    }

    @Override
    public String toString() {
        return "bytes{" + Debug.formatLiteral(Constant.newBuilder().setBytesValue(ByteString.copyFrom(this.b)).build()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesT bytesT = (BytesT)o;
        return Arrays.equals(this.b, bytesT.b);
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + Arrays.hashCode(this.b);
        return result;
    }
}

