/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.debug;

import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Expr;

public final class Debug {
    public String toDebugString(Expr e) {
        return Debug.toAdornedDebugString(e, new EmptyDebugAdorner());
    }

    public static String toAdornedDebugString(Expr e, Adorner adorner) {
        DebugWriter w = new DebugWriter(adorner);
        w.buffer(e);
        return w.toString();
    }

    public static String formatLiteral(Constant c) {
        switch (c.getConstantKindCase()) {
            case BOOL_VALUE: {
                return Boolean.toString(c.getBoolValue());
            }
            case BYTES_VALUE: {
                byte[] bytes;
                StringBuilder sb = new StringBuilder();
                sb.append("b\"");
                block31: for (byte b : bytes = c.getBytesValue().toByteArray()) {
                    int i = b & 0xFF;
                    if (i >= 32 && i <= 127 && i != 34) {
                        sb.append((char)i);
                        continue;
                    }
                    switch (i) {
                        case 7: {
                            sb.append("\\a");
                            continue block31;
                        }
                        case 8: {
                            sb.append("\\b");
                            continue block31;
                        }
                        case 9: {
                            sb.append("\\t");
                            continue block31;
                        }
                        case 10: {
                            sb.append("\\n");
                            continue block31;
                        }
                        case 11: {
                            sb.append("\\v");
                            continue block31;
                        }
                        case 12: {
                            sb.append("\\f");
                            continue block31;
                        }
                        case 13: {
                            sb.append("\\r");
                            continue block31;
                        }
                        case 34: {
                            sb.append("\\\"");
                            continue block31;
                        }
                        default: {
                            sb.append(String.format("\\x%02x", i));
                        }
                    }
                }
                sb.append("\"");
                return sb.toString();
            }
            case DOUBLE_VALUE: {
                return Double.toString(c.getDoubleValue());
            }
            case INT64_VALUE: {
                return Long.toString(c.getInt64Value());
            }
            case STRING_VALUE: {
                StringBuilder sb = new StringBuilder();
                sb.append('\"');
                String s = c.getStringValue();
                block32: for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    switch (ch) {
                        case '\u0007': {
                            sb.append("\\a");
                            continue block32;
                        }
                        case '\u000b': {
                            sb.append("\\v");
                            continue block32;
                        }
                        case '\t': {
                            sb.append("\\t");
                            continue block32;
                        }
                        case '\b': {
                            sb.append("\\b");
                            continue block32;
                        }
                        case '\n': {
                            sb.append("\\n");
                            continue block32;
                        }
                        case '\r': {
                            sb.append("\\r");
                            continue block32;
                        }
                        case '\f': {
                            sb.append("\\f");
                            continue block32;
                        }
                        case '\'': {
                            sb.append("'");
                            continue block32;
                        }
                        case '\"': {
                            sb.append("\\\"");
                            continue block32;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            continue block32;
                        }
                        default: {
                            if (Character.isDefined(ch)) {
                                sb.append(ch);
                                continue block32;
                            }
                            sb.append(String.format("\\u%04x", ch & 0xFFFF));
                        }
                    }
                }
                sb.append('\"');
                return sb.toString();
            }
            case UINT64_VALUE: {
                return Long.toUnsignedString(c.getUint64Value()) + "u";
            }
            case NULL_VALUE: {
                return null;
            }
        }
        throw new IllegalArgumentException("" + c);
    }

    static final class EmptyDebugAdorner
    implements Adorner {
        EmptyDebugAdorner() {
        }

        @Override
        public String getMetadata(Object e) {
            return "";
        }
    }

    public static interface Adorner {
        public String getMetadata(Object var1);
    }

    public static final class DebugWriter {
        final Adorner adorner;
        final StringBuilder buffer;
        int indent;
        boolean lineStart;

        public DebugWriter(Adorner a) {
            this.adorner = a;
            this.buffer = new StringBuilder();
            this.indent = 0;
            this.lineStart = true;
        }

        void buffer(Expr e) {
            if (e == null) {
                return;
            }
            switch (e.getExprKindCase()) {
                case CONST_EXPR: {
                    this.append(Debug.formatLiteral(e.getConstExpr()));
                    break;
                }
                case IDENT_EXPR: {
                    this.append(e.getIdentExpr().getName());
                    break;
                }
                case SELECT_EXPR: {
                    this.appendSelect(e.getSelectExpr());
                    break;
                }
                case CALL_EXPR: {
                    this.appendCall(e.getCallExpr());
                    break;
                }
                case LIST_EXPR: {
                    this.appendList(e.getListExpr());
                    break;
                }
                case STRUCT_EXPR: {
                    this.appendStruct(e.getStructExpr());
                    break;
                }
                case COMPREHENSION_EXPR: {
                    this.appendComprehension(e.getComprehensionExpr());
                    break;
                }
                case EXPRKIND_NOT_SET: {
                    throw new IllegalStateException("Expr w/o kind");
                }
            }
            this.adorn(e);
        }

        void appendSelect(Expr.Select sel) {
            this.buffer(sel.getOperand());
            this.append(".");
            this.append(sel.getField());
            if (sel.getTestOnly()) {
                this.append("~test-only~");
            }
        }

        void appendCall(Expr.Call call) {
            if (call.hasTarget()) {
                this.buffer(call.getTarget());
                this.append(".");
            }
            this.append(call.getFunction());
            this.append("(");
            if (call.getArgsCount() > 0) {
                this.addIndent();
                this.appendLine();
                for (int i = 0; i < call.getArgsCount(); ++i) {
                    if (i > 0) {
                        this.append(",");
                        this.appendLine();
                    }
                    this.buffer(call.getArgs(i));
                }
                this.removeIndent();
                this.appendLine();
            }
            this.append(")");
        }

        void appendList(Expr.CreateList list) {
            this.append("[");
            if (list.getElementsCount() > 0) {
                this.appendLine();
                this.addIndent();
                for (int i = 0; i < list.getElementsCount(); ++i) {
                    if (i > 0) {
                        this.append(",");
                        this.appendLine();
                    }
                    this.buffer(list.getElements(i));
                }
                this.removeIndent();
                this.appendLine();
            }
            this.append("]");
        }

        void appendStruct(Expr.CreateStruct obj) {
            if (!obj.getMessageName().isEmpty()) {
                this.appendObject(obj);
            } else {
                this.appendMap(obj);
            }
        }

        void appendObject(Expr.CreateStruct obj) {
            this.append(obj.getMessageName());
            this.append("{");
            if (obj.getEntriesCount() > 0) {
                this.appendLine();
                this.addIndent();
                for (int i = 0; i < obj.getEntriesCount(); ++i) {
                    if (i > 0) {
                        this.append(",");
                        this.appendLine();
                    }
                    Expr.CreateStruct.Entry entry = obj.getEntries(i);
                    this.append(entry.getFieldKey());
                    this.append(":");
                    this.buffer(entry.getValue());
                    this.adorn(entry);
                }
                this.removeIndent();
                this.appendLine();
            }
            this.append("}");
        }

        void appendMap(Expr.CreateStruct obj) {
            this.append("{");
            if (obj.getEntriesCount() > 0) {
                this.appendLine();
                this.addIndent();
                for (int i = 0; i < obj.getEntriesCount(); ++i) {
                    if (i > 0) {
                        this.append(",");
                        this.appendLine();
                    }
                    Expr.CreateStruct.Entry entry = obj.getEntries(i);
                    this.buffer(entry.getMapKey());
                    this.append(":");
                    this.buffer(entry.getValue());
                    this.adorn(entry);
                }
                this.removeIndent();
                this.appendLine();
            }
            this.append("}");
        }

        void appendComprehension(Expr.Comprehension comprehension) {
            this.append("__comprehension__(");
            this.addIndent();
            this.appendLine();
            this.append("// Variable");
            this.appendLine();
            this.append(comprehension.getIterVar());
            this.append(",");
            this.appendLine();
            this.append("// Target");
            this.appendLine();
            this.buffer(comprehension.getIterRange());
            this.append(",");
            this.appendLine();
            this.append("// Accumulator");
            this.appendLine();
            this.append(comprehension.getAccuVar());
            this.append(",");
            this.appendLine();
            this.append("// Init");
            this.appendLine();
            this.buffer(comprehension.getAccuInit());
            this.append(",");
            this.appendLine();
            this.append("// LoopCondition");
            this.appendLine();
            this.buffer(comprehension.getLoopCondition());
            this.append(",");
            this.appendLine();
            this.append("// LoopStep");
            this.appendLine();
            this.buffer(comprehension.getLoopStep());
            this.append(",");
            this.appendLine();
            this.append("// Result");
            this.appendLine();
            this.buffer(comprehension.getResult());
            this.append(")");
            this.removeIndent();
        }

        void append(String s) {
            this.doIndent();
            this.buffer.append(s);
        }

        void appendFormat(String f, Object ... args) {
            this.append(String.format(f, args));
        }

        void doIndent() {
            if (this.lineStart) {
                this.lineStart = false;
                for (int i = 0; i < this.indent; ++i) {
                    this.buffer.append("  ");
                }
            }
        }

        void adorn(Object e) {
            this.append(this.adorner.getMetadata(e));
        }

        void appendLine() {
            this.buffer.append("\n");
            this.lineStart = true;
        }

        void addIndent() {
            ++this.indent;
        }

        void removeIndent() {
            --this.indent;
            if (this.indent < 0) {
                throw new IllegalStateException("negative indent");
            }
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

