/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.containers;

import com.google.api.expr.v1alpha1.Expr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Container {
    public static final Container defaultContainer = new Container("", Collections.emptyMap());
    private final String name;
    private final Map<String, String> aliases;

    public static Container newContainer(ContainerOption ... opts) {
        Container c = defaultContainer;
        for (ContainerOption opt : opts) {
            if ((c = opt.apply(c)) != null) continue;
            return null;
        }
        return c;
    }

    private Container(String name, Map<String, String> aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public Container extend(ContainerOption ... opts) {
        HashMap<String, String> aliasSet = new HashMap<String, String>(this.aliasSet());
        Container ext = new Container(this.name(), aliasSet);
        for (ContainerOption opt : opts) {
            if ((ext = opt.apply(ext)) != null) continue;
            return null;
        }
        return ext;
    }

    public String[] resolveCandidateNames(String name) {
        if (name.startsWith(".")) {
            String qn = name.substring(1);
            String alias = this.findAlias(qn);
            if (alias != null) {
                return new String[]{alias};
            }
            return new String[]{qn};
        }
        String alias = this.findAlias(name);
        if (alias != null) {
            return new String[]{alias};
        }
        if (this.name() == null || this.name().isEmpty()) {
            return new String[]{name};
        }
        String nextCont = this.name();
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(nextCont + "." + name);
        int i = nextCont.lastIndexOf(46);
        while (i >= 0) {
            nextCont = nextCont.substring(0, i);
            candidates.add(nextCont + "." + name);
            i = nextCont.lastIndexOf(46, i - 1);
        }
        candidates.add(name);
        return candidates.toArray(new String[0]);
    }

    String findAlias(String name) {
        String alias;
        String simple = name;
        String qualifier = "";
        int dot = name.indexOf(46);
        if (dot >= 0) {
            simple = name.substring(0, dot);
            qualifier = name.substring(dot);
        }
        if ((alias = this.aliasSet().get(simple)) == null) {
            return null;
        }
        return alias + qualifier;
    }

    public static String toQualifiedName(Expr e) {
        switch (e.getExprKindCase()) {
            case IDENT_EXPR: {
                return e.getIdentExpr().getName();
            }
            case SELECT_EXPR: {
                Expr.Select sel = e.getSelectExpr();
                if (sel.getTestOnly()) {
                    return null;
                }
                String qual = Container.toQualifiedName(sel.getOperand());
                if (qual == null) break;
                return qual + "." + sel.getField();
            }
        }
        return null;
    }

    Map<String, String> aliasSet() {
        return this.aliases;
    }

    public static ContainerOption abbrevs(String ... qualifiedNames) {
        return c -> {
            for (String qn : qualifiedNames) {
                int ind = qn.lastIndexOf(46);
                if (ind <= 0 || ind >= qn.length() - 1) {
                    throw new IllegalArgumentException(String.format("invalid qualified name: %s, wanted name of the form 'qualified.name'", qn));
                }
                String alias = qn.substring(ind + 1);
                c = Container.aliasAs("abbreviation", qn, alias).apply(c);
                if (c != null) continue;
                return null;
            }
            return c;
        };
    }

    public static ContainerOption alias(String qualifiedName, String alias) {
        return Container.aliasAs("alias", qualifiedName, alias);
    }

    static ContainerOption aliasAs(String kind, String qualifiedName, String alias) {
        return c -> {
            if (alias.isEmpty() || alias.indexOf(46) != -1) {
                throw new IllegalArgumentException(String.format("%s must be non-empty and simple (not qualified): %s=%s", kind, kind, alias));
            }
            if (qualifiedName.charAt(0) == '.') {
                throw new IllegalArgumentException(String.format("qualified name must not begin with a leading '.': %s", qualifiedName));
            }
            int ind = qualifiedName.lastIndexOf(46);
            if (ind <= 0 || ind == qualifiedName.length() - 1) {
                throw new IllegalArgumentException(String.format("%s must refer to a valid qualified name: %s", kind, qualifiedName));
            }
            String aliasRef = c.aliasSet().get(alias);
            if (aliasRef != null) {
                throw new IllegalArgumentException(String.format("%s collides with existing reference: name=%s, %s=%s, existing=%s", kind, qualifiedName, kind, alias, aliasRef));
            }
            if (c.name().startsWith(alias + ".") || c.name().equals(alias)) {
                throw new IllegalArgumentException(String.format("%s collides with container name: name=%s, %s=%s, container=%s", kind, qualifiedName, kind, alias, c.name()));
            }
            HashMap<String, String> aliases = new HashMap<String, String>(c.aliasSet());
            aliases.put(alias, qualifiedName);
            c = new Container(c.name, aliases);
            return c;
        };
    }

    public static ContainerOption name(String name) {
        return c -> {
            if (!name.isEmpty() && name.charAt(0) == '.') {
                throw new IllegalArgumentException(String.format("container name must not contain a leading '.': %s", name));
            }
            if (c.name.equals(name)) {
                return c;
            }
            c = new Container(name, c.aliases);
            return c;
        };
    }

    @FunctionalInterface
    public static interface ContainerOption {
        public Container apply(Container var1);
    }
}

