/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common;

import com.google.api.expr.v1alpha1.SourceInfo;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.Location;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.SourceImpl;
import java.util.List;
import org.agrona.collections.IntArrayList;

public interface Source {
    public static Source newTextSource(String text) {
        return Source.newStringSource(text, "<input>");
    }

    public static Source newStringSource(String contents, String description) {
        IntArrayList offsets = new IntArrayList();
        int i = 0;
        while (i <= contents.length()) {
            int nl;
            if (i > 0) {
                offsets.add(i);
            }
            if ((nl = contents.indexOf(10, i)) == -1) {
                offsets.add(contents.length() + 1);
                break;
            }
            i = nl + 1;
        }
        return new SourceImpl(contents, description, offsets);
    }

    public static Source newInfoSource(SourceInfo info) {
        return new SourceImpl("", info.getLocation(), info.getLineOffsetsList(), info.getPositionsMap());
    }

    public String content();

    public String description();

    public List<Integer> lineOffsets();

    public int locationOffset(Location var1);

    public Location offsetLocation(int var1);

    public Location newLocation(int var1, int var2);

    public String snippet(int var1);
}

