/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.CELError;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.Location;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.Source;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Errors {
    private final List<CELError> errors = new ArrayList<CELError>();
    private final Source source;

    public Errors(Source source) {
        this.source = source;
    }

    public void reportError(Location l, String format, Object ... args) {
        this.reportError(null, l, format, args);
    }

    public void reportError(Exception e, Location l, String format, Object ... args) {
        CELError err = new CELError(e, l, String.format(format, args));
        this.errors.add(err);
    }

    public List<CELError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Errors append(List<CELError> errors) {
        Errors errs = new Errors(this.source);
        errs.errors.addAll(this.errors);
        errs.errors.addAll(errors);
        return errs;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.errors.stream().sorted().map(e -> e.toDisplayString(this.source)).collect(Collectors.joining("\n"));
    }

    public void syntaxError(Location l, String msg) {
        this.reportError(l, "Syntax error: %s", msg);
    }
}

