/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.Decl;
import java.util.HashMap;
import java.util.Map;

public final class Scopes {
    private final Scopes parent;
    private final Group scopes;

    private Scopes(Scopes parent, Group scopes) {
        this.parent = parent;
        this.scopes = scopes;
    }

    public static Scopes newScopes() {
        return new Scopes(null, Scopes.newGroup());
    }

    public Scopes push() {
        return new Scopes(this, Scopes.newGroup());
    }

    public Scopes pop() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    public void addIdent(Decl decl) {
        this.scopes.idents.put(decl.getName(), decl);
    }

    public Decl findIdent(String name) {
        Decl ident = (Decl)this.scopes.idents.get(name);
        if (ident != null) {
            return ident;
        }
        if (this.parent != null) {
            return this.parent.findIdent(name);
        }
        return null;
    }

    public Decl findIdentInScope(String name) {
        return (Decl)this.scopes.idents.get(name);
    }

    public void addFunction(Decl fn) {
        this.scopes.functions.put(fn.getName(), fn);
    }

    public Decl findFunction(String name) {
        Decl ident = (Decl)this.scopes.functions.get(name);
        if (ident != null) {
            return ident;
        }
        if (this.parent != null) {
            return this.parent.findFunction(name);
        }
        return null;
    }

    public Decl updateFunction(String name, Decl ident) {
        if (this.scopes.functions.containsKey(name)) {
            this.scopes.functions.put(name, ident);
        } else if (this.parent != null) {
            return this.parent.updateFunction(name, ident);
        }
        return null;
    }

    static Group newGroup() {
        return new Group(new HashMap(), new HashMap());
    }

    public static final class Group {
        private final Map<String, Decl> idents;
        private final Map<String, Decl> functions;

        private Group(Map<String, Decl> idents, Map<String, Decl> functions) {
            this.idents = idents;
            this.functions = functions;
        }
    }
}

