/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import java.util.Arrays;
import java.util.List;

public final class Decls {
    public static final Type Error = Type.newBuilder().setError(Empty.getDefaultInstance()).build();
    public static final Type Dyn = Type.newBuilder().setDyn(Empty.getDefaultInstance()).build();
    public static final Type Bool = Decls.newPrimitiveType(Type.PrimitiveType.BOOL);
    public static final Type Bytes = Decls.newPrimitiveType(Type.PrimitiveType.BYTES);
    public static final Type Double = Decls.newPrimitiveType(Type.PrimitiveType.DOUBLE);
    public static final Type Int = Decls.newPrimitiveType(Type.PrimitiveType.INT64);
    public static final Type Null = Type.newBuilder().setNull(NullValue.NULL_VALUE).build();
    public static final Type String = Decls.newPrimitiveType(Type.PrimitiveType.STRING);
    public static final Type Uint = Decls.newPrimitiveType(Type.PrimitiveType.UINT64);
    public static final Type Any = Decls.newWellKnownType(Type.WellKnownType.ANY);
    public static final Type Duration = Decls.newWellKnownType(Type.WellKnownType.DURATION);
    public static final Type Timestamp = Decls.newWellKnownType(Type.WellKnownType.TIMESTAMP);

    public static Type newAbstractType(String name, List<Type> paramTypes) {
        return Type.newBuilder().setAbstractType(Type.AbstractType.newBuilder().setName(name).addAllParameterTypes(paramTypes)).build();
    }

    public static Type newFunctionType(Type resultType, List<Type> argTypes) {
        return Type.newBuilder().setFunction(Type.FunctionType.newBuilder().setResultType(resultType).addAllArgTypes(argTypes)).build();
    }

    public static Decl newFunction(String name, Decl.FunctionDecl.Overload ... overloads) {
        return Decls.newFunction(name, Arrays.asList(overloads));
    }

    public static Decl newFunction(String name, List<Decl.FunctionDecl.Overload> overloads) {
        return Decl.newBuilder().setName(name).setFunction(Decl.FunctionDecl.newBuilder().addAllOverloads(overloads).build()).build();
    }

    public static Decl newIdent(String name, Type t, Constant v) {
        Decl.IdentDecl.Builder ident = Decl.IdentDecl.newBuilder().setType(t);
        if (v != null) {
            ident = ident.setValue(v);
        }
        return Decl.newBuilder().setName(name).setIdent(ident).build();
    }

    public static Decl newConst(String name, Type t, Constant v) {
        return Decls.newIdent(name, t, v);
    }

    public static Decl newVar(String name, Type t) {
        return Decls.newIdent(name, t, null);
    }

    public static Decl.FunctionDecl.Overload newInstanceOverload(String id, List<Type> argTypes, Type resultType) {
        return Decl.FunctionDecl.Overload.newBuilder().setOverloadId(id).setResultType(resultType).addAllParams(argTypes).setIsInstanceFunction(true).build();
    }

    public static Type newListType(Type elem) {
        return Type.newBuilder().setListType(Type.ListType.newBuilder().setElemType(elem)).build();
    }

    public static Type newMapType(Type key, Type value) {
        return Type.newBuilder().setMapType(Type.MapType.newBuilder().setKeyType(key).setValueType(value)).build();
    }

    public static Type newObjectType(String typeName) {
        return Type.newBuilder().setMessageType(typeName).build();
    }

    public static Decl.FunctionDecl.Overload newOverload(String id, List<Type> argTypes, Type resultType) {
        return Decl.FunctionDecl.Overload.newBuilder().setOverloadId(id).setResultType(resultType).addAllParams(argTypes).setIsInstanceFunction(false).build();
    }

    public static Decl.FunctionDecl.Overload newParameterizedInstanceOverload(String id, List<Type> argTypes, Type resultType, List<String> typeParams) {
        return Decl.FunctionDecl.Overload.newBuilder().setOverloadId(id).setResultType(resultType).addAllParams(argTypes).addAllTypeParams(typeParams).setIsInstanceFunction(true).build();
    }

    public static Decl.FunctionDecl.Overload newParameterizedOverload(String id, List<Type> argTypes, Type resultType, List<String> typeParams) {
        return Decl.FunctionDecl.Overload.newBuilder().setOverloadId(id).setResultType(resultType).addAllParams(argTypes).addAllTypeParams(typeParams).setIsInstanceFunction(false).build();
    }

    public static Type newPrimitiveType(Type.PrimitiveType primitive) {
        return Type.newBuilder().setPrimitive(primitive).build();
    }

    public static Type newTypeType(Type nested) {
        if (nested == null) {
            nested = Type.newBuilder().build();
        }
        return Type.newBuilder().setType(nested).build();
    }

    public static Type newTypeParamType(String name) {
        return Type.newBuilder().setTypeParam(name).build();
    }

    public static Type newWellKnownType(Type.WellKnownType wellKnown) {
        return Type.newBuilder().setWellKnown(wellKnown).build();
    }

    public static Type newWrapperType(Type wrapped) {
        Type.PrimitiveType primitive = wrapped.getPrimitive();
        if (primitive == Type.PrimitiveType.PRIMITIVE_TYPE_UNSPECIFIED) {
            throw new IllegalArgumentException(java.lang.String.format("Wrapped type must be a primitive, but is '%s'", wrapped));
        }
        return Type.newBuilder().setWrapper(primitive).build();
    }
}

