/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel;

import io.cryostat.agent.shaded.org.projectnessie.cel.CEL;
import io.cryostat.agent.shaded.org.projectnessie.cel.Env;
import io.cryostat.agent.shaded.org.projectnessie.cel.EvalDetails;
import io.cryostat.agent.shaded.org.projectnessie.cel.EvalOption;
import io.cryostat.agent.shaded.org.projectnessie.cel.Program;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Activation;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.AttributeFactory;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Coster;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Dispatcher;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.EvalState;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Interpretable;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.InterpretableDecorator;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Interpreter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

final class Prog
implements Program,
Coster {
    static final EvalState emptyEvalState = EvalState.newEvalState();
    final Env e;
    final Set<EvalOption> evalOpts = EnumSet.noneOf(EvalOption.class);
    final List<InterpretableDecorator> decorators = new ArrayList<InterpretableDecorator>();
    Activation defaultVars;
    final Dispatcher dispatcher;
    Interpreter interpreter;
    Interpretable interpretable;
    AttributeFactory attrFactory;
    final EvalState state;

    Prog(Env e, Dispatcher dispatcher) {
        this.e = e;
        this.dispatcher = dispatcher;
        this.state = EvalState.newEvalState();
    }

    Prog(Env e, Set<EvalOption> evalOpts, Activation defaultVars, Dispatcher dispatcher, Interpreter interpreter, EvalState state) {
        this.e = e;
        this.evalOpts.addAll(evalOpts);
        this.defaultVars = defaultVars;
        this.dispatcher = dispatcher;
        this.interpreter = interpreter;
        this.state = state;
    }

    @Override
    public Program.EvalResult eval(Object input) {
        Val v;
        EvalDetails evalDetails = new EvalDetails(this.state);
        try {
            Activation vars = Activation.newActivation(input);
            if (this.defaultVars != null) {
                vars = Activation.newHierarchicalActivation(this.defaultVars, vars);
            }
            v = this.interpretable.eval(vars);
        }
        catch (Err.ErrException e) {
            v = e.getErr();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("internal error: %s", e.getMessage()), e);
        }
        return Program.newEvalResult(v, evalDetails);
    }

    @Override
    public Coster.Cost cost() {
        return CEL.estimateCost(this.interpretable);
    }
}

