/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel;

import io.cryostat.agent.shaded.org.projectnessie.cel.EnvOption;
import io.cryostat.agent.shaded.org.projectnessie.cel.ProgramOption;
import io.cryostat.agent.shaded.org.projectnessie.cel.checker.Checker;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.Overload;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Macro;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface Library {
    public List<EnvOption> getCompileOptions();

    public List<ProgramOption> getProgramOptions();

    public static EnvOption Lib(Library l) {
        return e -> {
            for (EnvOption opt : l.getCompileOptions()) {
                e = opt.apply(e);
                if (e != null) continue;
                throw new NullPointerException(String.format("env option of type '%s' returned null", opt.getClass().getName()));
            }
            e.addProgOpts(l.getProgramOptions());
            return e;
        };
    }

    public static EnvOption StdLib() {
        return Library.Lib(new StdLibrary());
    }

    public static final class StdLibrary
    implements Library {
        @Override
        public List<EnvOption> getCompileOptions() {
            return Arrays.asList(EnvOption.declarations(Checker.StandardDeclarations), EnvOption.macros(Macro.AllMacros));
        }

        @Override
        public List<ProgramOption> getProgramOptions() {
            return Collections.singletonList(ProgramOption.functions(Overload.standardOverloads()));
        }
    }
}

