/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel;

import com.google.api.expr.v1alpha1.Decl;
import io.cryostat.agent.shaded.org.projectnessie.cel.Env;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.containers.Container;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeAdapter;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeProvider;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeRegistry;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Macro;
import java.util.Arrays;
import java.util.List;

@FunctionalInterface
public interface EnvOption {
    public Env apply(Env var1);

    public static EnvOption clearMacros() {
        return e -> {
            e.macros.clear();
            return e;
        };
    }

    public static EnvOption customTypeAdapter(TypeAdapter adapter) {
        return e -> {
            e.adapter = adapter;
            return e;
        };
    }

    public static EnvOption customTypeProvider(TypeProvider provider) {
        return e -> {
            e.provider = provider;
            return e;
        };
    }

    public static EnvOption declarations(List<Decl> decls) {
        return e -> {
            e.declarations.addAll(decls);
            return e;
        };
    }

    public static EnvOption declarations(Decl ... decls) {
        return EnvOption.declarations(Arrays.asList(decls));
    }

    public static EnvOption features(EnvFeature ... flags) {
        return e -> {
            for (EnvFeature flag : flags) {
                e.setFeature(flag);
            }
            return e;
        };
    }

    public static EnvOption homogeneousAggregateLiterals() {
        return EnvOption.features(EnvFeature.FeatureDisableDynamicAggregateLiterals);
    }

    public static EnvOption macros(Macro ... macros) {
        return EnvOption.macros(Arrays.asList(macros));
    }

    public static EnvOption macros(List<Macro> macros) {
        return e -> {
            e.macros.addAll(macros);
            return e;
        };
    }

    public static EnvOption container(String name) {
        return e -> {
            e.container = e.container.extend(Container.name(name));
            return e;
        };
    }

    public static EnvOption abbrevs(String ... qualifiedNames) {
        return e -> {
            e.container = e.container.extend(Container.abbrevs(qualifiedNames));
            return e;
        };
    }

    public static EnvOption types(List<Object> addTypes) {
        return e -> {
            if (!(e.provider instanceof TypeRegistry)) {
                throw new RuntimeException(String.format("custom types not supported by provider: %s", e.provider.getClass().getName()));
            }
            TypeRegistry reg = (TypeRegistry)e.provider;
            for (Object t : addTypes) {
                reg.register(t);
            }
            return e;
        };
    }

    public static EnvOption types(Object ... addTypes) {
        return EnvOption.types(Arrays.asList(addTypes));
    }

    public static enum EnvFeature {
        FeatureDisableDynamicAggregateLiterals;

    }
}

