/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.protocol;

import io.cryostat.agent.shaded.org.apache.shaded.http.HttpConnection;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpException;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpHost;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpInetConnection;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpRequest;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpRequestInterceptor;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpVersion;
import io.cryostat.agent.shaded.org.apache.shaded.http.ProtocolException;
import io.cryostat.agent.shaded.org.apache.shaded.http.ProtocolVersion;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpCoreContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

