/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.protocol;

import io.cryostat.agent.shaded.org.apache.shaded.http.HttpEntity;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpEntityEnclosingRequest;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpException;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpRequest;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpRequestInterceptor;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpVersion;
import io.cryostat.agent.shaded.org.apache.shaded.http.ProtocolVersion;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

