/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.impl.pool;

import io.cryostat.agent.shaded.org.apache.shaded.http.HttpClientConnection;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpHost;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.config.ConnectionConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.config.SocketConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.pool.BasicConnFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.pool.BasicPoolEntry;
import io.cryostat.agent.shaded.org.apache.shaded.http.params.HttpParams;
import io.cryostat.agent.shaded.org.apache.shaded.http.pool.AbstractConnPool;
import io.cryostat.agent.shaded.org.apache.shaded.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

