/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.impl.execchain;

import io.cryostat.agent.shaded.org.apache.shaded.commons.logging.Log;
import io.cryostat.agent.shaded.org.apache.shaded.commons.logging.LogFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.Header;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpException;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.ServiceUnavailableRetryStrategy;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.methods.CloseableHttpResponse;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.methods.HttpExecutionAware;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.methods.HttpRequestWrapper;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.protocol.HttpClientContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.routing.HttpRoute;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.execchain.ClientExecChain;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.execchain.RequestEntityProxy;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

