/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.impl.cookie;

import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.ClientCookie;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.CommonCookieAttributeHandler;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.Cookie;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.CookieOrigin;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.CookieRestrictionViolationException;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.MalformedCookieException;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.SetCookie;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.SetCookie2;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

