/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.impl.cookie;

import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.utils.DateUtils;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.CommonCookieAttributeHandler;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.MalformedCookieException;
import io.cryostat.agent.shaded.org.apache.shaded.http.cookie.SetCookie;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.cookie.AbstractCookieAttributeHandler;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datePatterns;

    public BasicExpiresHandler(String[] datePatterns) {
        Args.notNull(datePatterns, "Array of date patterns");
        this.datePatterns = (String[])datePatterns.clone();
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datePatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

