/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.impl.client;

import io.cryostat.agent.shaded.org.apache.shaded.http.ConnectionReuseStrategy;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpEntity;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpException;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpHost;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpResponse;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpVersion;
import io.cryostat.agent.shaded.org.apache.shaded.http.auth.AuthSchemeRegistry;
import io.cryostat.agent.shaded.org.apache.shaded.http.auth.AuthScope;
import io.cryostat.agent.shaded.org.apache.shaded.http.auth.AuthState;
import io.cryostat.agent.shaded.org.apache.shaded.http.auth.Credentials;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.config.RequestConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.params.HttpClientParamConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.protocol.RequestClientConnControl;
import io.cryostat.agent.shaded.org.apache.shaded.http.config.ConnectionConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.HttpConnectionFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.ManagedHttpClientConnection;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.routing.HttpRoute;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.routing.RouteInfo;
import io.cryostat.agent.shaded.org.apache.shaded.http.entity.BufferedHttpEntity;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.DefaultConnectionReuseStrategy;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.auth.BasicSchemeFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.auth.DigestSchemeFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.auth.HttpAuthenticator;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.auth.KerberosSchemeFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.auth.NTLMSchemeFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.auth.SPNegoSchemeFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.client.BasicCredentialsProvider;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.client.ProxyAuthenticationStrategy;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.conn.ManagedHttpClientConnectionFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.execchain.TunnelRefusedException;
import io.cryostat.agent.shaded.org.apache.shaded.http.message.BasicHttpRequest;
import io.cryostat.agent.shaded.org.apache.shaded.http.params.BasicHttpParams;
import io.cryostat.agent.shaded.org.apache.shaded.http.params.HttpParamConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.params.HttpParams;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.BasicHttpContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpProcessor;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpRequestExecutor;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.ImmutableHttpProcessor;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.RequestTargetHost;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.RequestUserAgent;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.EntityUtils;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams params) {
        this(null, HttpParamConfig.getConnectionConfig(params), HttpClientParamConfig.getRequestConfig(params));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        HttpEntity entity;
        int status;
        HttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost host = target;
        if (host.getPort() <= 0) {
            host = new HttpHost(host.getHostName(), 80, host.getSchemeName());
        }
        HttpRoute route = new HttpRoute(host, this.requestConfig.getLocalAddress(), proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.create(route, this.connectionConfig);
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", host.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request", connect);
        context.setAttribute("http.route", route);
        context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        context.setAttribute("http.auth.credentials-provider", credsProvider);
        context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        context.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(connect, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.generateAuthResponse(connect, this.proxyAuthState, context);
            response = this.requestExec.execute(connect, conn, context);
            status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.handleAuthChallenge(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect.removeHeaders("Proxy-Authorization");
        }
        status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }
}

