/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.entity.mime;

import io.cryostat.agent.shaded.org.apache.shaded.http.entity.ContentType;
import io.cryostat.agent.shaded.org.apache.shaded.http.entity.mime.Header;
import io.cryostat.agent.shaded.org.apache.shaded.http.entity.mime.MinimalField;
import io.cryostat.agent.shaded.org.apache.shaded.http.entity.mime.content.AbstractContentBody;
import io.cryostat.agent.shaded.org.apache.shaded.http.entity.mime.content.ContentBody;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;

public class FormBodyPart {
    private final String name;
    private final Header header;
    private final ContentBody body;

    FormBodyPart(String name, ContentBody body, Header header) {
        Args.notNull(name, "Name");
        Args.notNull(body, "Body");
        this.name = name;
        this.body = body;
        this.header = header != null ? header : new Header();
    }

    @Deprecated
    public FormBodyPart(String name, ContentBody body) {
        Args.notNull(name, "Name");
        Args.notNull(body, "Body");
        this.name = name;
        this.body = body;
        this.header = new Header();
        this.generateContentDisp(body);
        this.generateContentType(body);
        this.generateTransferEncoding(body);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addField(String name, String value) {
        Args.notNull(name, "Field name");
        this.header.addField(new MinimalField(name, value));
    }

    @Deprecated
    protected void generateContentDisp(ContentBody body) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("form-data; name=\"");
        buffer.append(this.getName());
        buffer.append("\"");
        if (body.getFilename() != null) {
            buffer.append("; filename=\"");
            buffer.append(body.getFilename());
            buffer.append("\"");
        }
        this.addField("Content-Disposition", buffer.toString());
    }

    @Deprecated
    protected void generateContentType(ContentBody body) {
        ContentType contentType = body instanceof AbstractContentBody ? ((AbstractContentBody)body).getContentType() : null;
        if (contentType != null) {
            this.addField("Content-Type", contentType.toString());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(body.getMimeType());
            if (body.getCharset() != null) {
                buffer.append("; charset=");
                buffer.append(body.getCharset());
            }
            this.addField("Content-Type", buffer.toString());
        }
    }

    @Deprecated
    protected void generateTransferEncoding(ContentBody body) {
        this.addField("Content-Transfer-Encoding", body.getTransferEncoding());
    }
}

