/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.apache.shaded.http.client.protocol;

import io.cryostat.agent.shaded.org.apache.shaded.commons.logging.Log;
import io.cryostat.agent.shaded.org.apache.shaded.commons.logging.LogFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpException;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpRequest;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpRequestInterceptor;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.Contract;
import io.cryostat.agent.shaded.org.apache.shaded.http.annotation.ThreadingBehavior;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.protocol.HttpClientContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.routing.RouteInfo;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

