/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config.inject;

import io.cryostat.agent.shaded.io.smallrye.config.ConfigMapping;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappings;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigValidationException;
import io.cryostat.agent.shaded.io.smallrye.config.SmallRyeConfig;
import io.cryostat.agent.shaded.io.smallrye.config.inject.ConfigInjectionBean;
import io.cryostat.agent.shaded.io.smallrye.config.inject.ConfigMappingInjectionBean;
import io.cryostat.agent.shaded.io.smallrye.config.inject.ConfigProducer;
import io.cryostat.agent.shaded.io.smallrye.config.inject.ConfigProducerUtil;
import io.cryostat.agent.shaded.io.smallrye.config.inject.ConfigPropertiesInjectionBean;
import io.cryostat.agent.shaded.io.smallrye.config.inject.InjectionMessages;
import io.cryostat.agent.shaded.io.smallrye.config.inject.SecuritySupport;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.ConfigProvider;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.ConfigValue;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.inject.ConfigProperties;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.inject.ConfigProperty;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Provider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ConfigExtension
implements Extension {
    private final Set<InjectionPoint> configPropertyInjectionPoints = new HashSet<InjectionPoint>();
    private final Set<ConfigMappings.ConfigClassWithPrefix> configProperties = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
    private final Set<ConfigMappings.ConfigClassWithPrefix> configPropertiesBeans = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
    private final Set<ConfigMappings.ConfigClassWithPrefix> configMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
    private final Set<ConfigMappings.ConfigClassWithPrefix> configMappingBeans = new HashSet<ConfigMappings.ConfigClassWithPrefix>();

    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType configBean = bm.createAnnotatedType(ConfigProducer.class);
        bbd.addAnnotatedType(configBean, ConfigProducer.class.getName());
        AnnotatedTypeConfigurator configPropertiesConfigurator = bbd.configureQualifier(ConfigProperties.class);
        configPropertiesConfigurator.methods().forEach(methodConfigurator -> methodConfigurator.remove(annotation -> annotation.annotationType().equals(Nonbinding.class)));
    }

    protected void processConfigProperties(@Observes @WithAnnotations(value={ConfigProperties.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(ConfigProperties.class)) {
            processAnnotatedType.veto();
            ConfigMappings.ConfigClassWithPrefix properties = ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(processAnnotatedType.getAnnotatedType().getJavaClass(), ((ConfigProperties)processAnnotatedType.getAnnotatedType().getAnnotation(ConfigProperties.class)).prefix());
            if (!properties.getPrefix().equals("io.cryostat.agent.shaded.org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
                this.configProperties.add(properties);
            } else {
                this.configProperties.add(ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(properties.getKlass(), ""));
            }
            this.configPropertiesBeans.add(properties);
        }
    }

    protected void processConfigMappings(@Observes @WithAnnotations(value={ConfigMapping.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(ConfigMapping.class)) {
            processAnnotatedType.veto();
            ConfigMappings.ConfigClassWithPrefix mapping = ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(processAnnotatedType.getAnnotatedType().getJavaClass(), ((ConfigMapping)processAnnotatedType.getAnnotatedType().getAnnotation(ConfigMapping.class)).prefix());
            this.configMappings.add(mapping);
            this.configMappingBeans.add(mapping);
        }
    }

    protected void processConfigInjectionPoints(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigMappings.ConfigClassWithPrefix mapping;
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperty.class)) {
            this.configPropertyInjectionPoints.add(pip.getInjectionPoint());
        }
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperties.class)) {
            ConfigMappings.ConfigClassWithPrefix properties = ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix((Class)pip.getInjectionPoint().getType(), ((ConfigProperties)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperties.class)).prefix());
            if (!properties.getPrefix().equals("io.cryostat.agent.shaded.org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
                this.configProperties.add(properties);
            }
            this.configPropertiesBeans.add(properties);
        }
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigMapping.class) && !(mapping = ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix((Class)pip.getInjectionPoint().getType(), ((ConfigMapping)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigMapping.class)).prefix())).getPrefix().isEmpty()) {
            this.configMappings.add(mapping);
        }
    }

    protected void registerCustomBeans(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        HashSet<Class> customTypes = new HashSet<Class>();
        for (InjectionPoint ip : this.configPropertyInjectionPoints) {
            Type requiredType = ip.getType();
            if (requiredType instanceof ParameterizedType) {
                Type typeArgument;
                ParameterizedType type = (ParameterizedType)requiredType;
                if (!type.getRawType().equals(Provider.class) && !type.getRawType().equals(Instance.class) || !((typeArgument = type.getActualTypeArguments()[0]) instanceof Class) || ConfigProducer.isClassHandledByConfigProducer(typeArgument)) continue;
                customTypes.add((Class)typeArgument);
                continue;
            }
            if (!(requiredType instanceof Class) || ConfigProducer.isClassHandledByConfigProducer(requiredType)) continue;
            customTypes.add((Class)requiredType);
        }
        customTypes.forEach(customType -> abd.addBean(new ConfigInjectionBean(bm, (Class<?>)customType)));
        this.configPropertiesBeans.forEach(properties -> abd.addBean(new ConfigPropertiesInjectionBean((ConfigMappings.ConfigClassWithPrefix)properties)));
        this.configMappingBeans.forEach(mapping -> abd.addBean(new ConfigMappingInjectionBean((ConfigMappings.ConfigClassWithPrefix)mapping, bm)));
    }

    protected void validate(@Observes AfterDeploymentValidation adv) {
        SmallRyeConfig config = ConfigProvider.getConfig(SecuritySupport.getContextClassLoader()).unwrap(SmallRyeConfig.class);
        Set configNames = StreamSupport.stream(config.getPropertyNames().spliterator(), false).collect(Collectors.toSet());
        for (InjectionPoint injectionPoint : this.getConfigPropertyInjectionPoints()) {
            String name;
            Type type = injectionPoint.getType();
            ConfigProperty configProperty = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            try {
                name = ConfigProducerUtil.getConfigKey(injectionPoint, configProperty);
            }
            catch (IllegalStateException e) {
                adv.addDeploymentProblem((Throwable)InjectionMessages.msg.retrieveConfigFailure(null, InjectionMessages.formatInjectionPoint(injectionPoint), e.getLocalizedMessage(), e));
                continue;
            }
            if (type instanceof Class && ConfigValue.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalInt.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalLong.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalDouble.class.isAssignableFrom((Class)type) || type instanceof ParameterizedType && (Optional.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Provider.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Supplier.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()))) continue;
            if (!configNames.contains(name) && ConfigProducerUtil.getConfigValue(name, config).getValue() == null && !ConfigExtension.isIndexed(type, name, config) && !ConfigExtension.isMap(type, name, config) && configProperty.defaultValue().equals("io.cryostat.agent.shaded.org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                adv.addDeploymentProblem((Throwable)InjectionMessages.msg.noConfigValue(name, InjectionMessages.formatInjectionPoint(injectionPoint)));
                continue;
            }
            try {
                ConfigProducerUtil.getValue(injectionPoint, config);
            }
            catch (Exception e) {
                adv.addDeploymentProblem((Throwable)InjectionMessages.msg.retrieveConfigFailure(name, InjectionMessages.formatInjectionPoint(injectionPoint), e.getLocalizedMessage(), e));
            }
        }
        try {
            ConfigMappings.registerConfigMappings(config, this.configMappings);
            ConfigMappings.registerConfigProperties(config, this.configProperties);
        }
        catch (ConfigValidationException e) {
            adv.addDeploymentProblem((Throwable)e);
        }
    }

    protected Set<InjectionPoint> getConfigPropertyInjectionPoints() {
        return this.configPropertyInjectionPoints;
    }

    private static boolean isIndexed(Type type, String name, SmallRyeConfig config) {
        return type instanceof ParameterizedType && (List.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Set.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) && !config.getIndexedPropertiesIndexes(name).isEmpty();
    }

    private static boolean isMap(Type type, String name, SmallRyeConfig config) {
        return type instanceof ParameterizedType && Map.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) && !config.getMapKeys(name).isEmpty();
    }
}

