/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.SecuritySupport;
import io.cryostat.agent.shaded.io.smallrye.config.SmallRyeConfigBuilder;
import io.cryostat.agent.shaded.io.smallrye.config.SmallRyeConfigFactory;
import io.cryostat.agent.shaded.io.smallrye.config._private.ConfigMessages;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.Config;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class SmallRyeConfigProviderResolver
extends ConfigProviderResolver {
    private final Map<ClassLoader, Config> configsForClassLoader = new ConcurrentHashMap<ClassLoader, Config>();
    static final ClassLoader SYSTEM_CL;

    private static ClassLoader calculateSystemClassLoader() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl == null) {
            cl = new ClassLoader(null){};
        }
        return cl;
    }

    @Override
    public Config getConfig() {
        return this.getConfig(SecuritySupport.getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config getConfig(ClassLoader classLoader) {
        Map<ClassLoader, Config> configsForClassLoader = this.configsForClassLoader;
        ClassLoader realClassLoader = SmallRyeConfigProviderResolver.getRealClassLoader(classLoader);
        Config config = configsForClassLoader.get(realClassLoader);
        if (config == null) {
            Map<ClassLoader, Config> map = configsForClassLoader;
            synchronized (map) {
                config = configsForClassLoader.get(realClassLoader);
                if (config == null) {
                    config = this.getFactoryFor(realClassLoader, false).getConfigFor(this, classLoader);
                    if (config == null) {
                        throw ConfigMessages.msg.noConfigForClassloader();
                    }
                    configsForClassLoader.put(realClassLoader, config);
                }
            }
        }
        return config;
    }

    SmallRyeConfigFactory getFactoryFor(final ClassLoader classLoader, boolean privileged) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !privileged) {
            return AccessController.doPrivileged(new PrivilegedAction<SmallRyeConfigFactory>(){

                @Override
                public SmallRyeConfigFactory run() {
                    return SmallRyeConfigProviderResolver.this.getFactoryFor(classLoader, true);
                }
            });
        }
        ServiceLoader<SmallRyeConfigFactory> serviceLoader = ServiceLoader.load(SmallRyeConfigFactory.class, classLoader);
        Iterator<SmallRyeConfigFactory> iterator = serviceLoader.iterator();
        return iterator.hasNext() ? iterator.next() : SmallRyeConfigFactory.Default.INSTANCE;
    }

    @Override
    public SmallRyeConfigBuilder getBuilder() {
        return new SmallRyeConfigBuilder().addDefaultInterceptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConfig(Config config, ClassLoader classLoader) {
        Map<ClassLoader, Config> configsForClassLoader;
        if (config == null) {
            throw ConfigMessages.msg.configIsNull();
        }
        ClassLoader realClassLoader = SmallRyeConfigProviderResolver.getRealClassLoader(classLoader);
        Map<ClassLoader, Config> map = configsForClassLoader = this.configsForClassLoader;
        synchronized (map) {
            Config existing = configsForClassLoader.putIfAbsent(realClassLoader, config);
            if (existing != null) {
                throw ConfigMessages.msg.configAlreadyRegistered();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConfig(Config config) {
        Map<ClassLoader, Config> configsForClassLoader;
        Map<ClassLoader, Config> map = configsForClassLoader = this.configsForClassLoader;
        synchronized (map) {
            configsForClassLoader.values().removeIf(v -> v == config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConfig(ClassLoader classLoader) {
        Map<ClassLoader, Config> configsForClassLoader;
        ClassLoader realClassLoader = SmallRyeConfigProviderResolver.getRealClassLoader(classLoader);
        Map<ClassLoader, Config> map = configsForClassLoader = this.configsForClassLoader;
        synchronized (map) {
            configsForClassLoader.remove(realClassLoader);
        }
    }

    static ClassLoader getRealClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = SecuritySupport.getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = SYSTEM_CL;
        }
        return classLoader;
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        SYSTEM_CL = sm != null ? AccessController.doPrivileged(SmallRyeConfigProviderResolver::calculateSystemClassLoader) : SmallRyeConfigProviderResolver.calculateSystemClassLoader();
    }
}

