/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.ConfigValue;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigValueConfigSource;
import io.cryostat.agent.shaded.io.smallrye.config.MapBackedConfigValueConfigSource;
import io.cryostat.agent.shaded.io.smallrye.config.common.utils.ConfigSourceUtil;
import io.smallrye.common.classloader.ClassPathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

public class PropertiesConfigSource
extends MapBackedConfigValueConfigSource {
    private static final long serialVersionUID = 1866835565147832432L;
    private static final String NAME_PREFIX = "PropertiesConfigSource[source=";

    public PropertiesConfigSource(URL url) throws IOException {
        this(url, 100);
    }

    public PropertiesConfigSource(URL url, int defaultOrdinal) throws IOException {
        this(url, NAME_PREFIX + url.toString() + "]", defaultOrdinal);
    }

    public PropertiesConfigSource(URL url, String name, int defaultOrdinal) throws IOException {
        super(name, PropertiesConfigSource.urlToConfigValueMap(url, name, defaultOrdinal), defaultOrdinal);
    }

    public PropertiesConfigSource(Map<String, String> properties, String name) {
        this(properties, name, 100);
    }

    public PropertiesConfigSource(Properties properties, String name) {
        this(ConfigSourceUtil.propertiesToMap(properties), name, 100);
    }

    public PropertiesConfigSource(Map<String, String> properties, String name, int defaultOrdinal) {
        super(NAME_PREFIX + name + "]", new ConfigValueConfigSource.ConfigValueMapStringView(properties, name, ConfigSourceUtil.getOrdinalFromMap(properties, defaultOrdinal)), defaultOrdinal);
    }

    public PropertiesConfigSource(Properties properties, String name, int defaultOrdinal) {
        this(ConfigSourceUtil.propertiesToMap(properties), name, defaultOrdinal);
    }

    public static Map<String, ConfigValue> urlToConfigValueMap(URL locationOfProperties, String name, int ordinal) throws IOException {
        ConfigValueConfigSource.ConfigValueProperties properties = new ConfigValueConfigSource.ConfigValueProperties(name, ordinal);
        ClassPathUtils.consumeStream(locationOfProperties, inputStream -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return properties;
    }
}

