/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.PropertyName;
import io.cryostat.agent.shaded.io.smallrye.config.common.AbstractConfigSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DefaultValuesConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -6386021034957868328L;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<PropertyName, String> wildcards = new HashMap<PropertyName, String>();

    public DefaultValuesConfigSource(Map<String, String> properties) {
        this(properties, "DefaultValuesConfigSource", Integer.MIN_VALUE);
    }

    public DefaultValuesConfigSource(Map<String, String> properties, String name, int ordinal) {
        super(name, ordinal);
        this.addDefaults(properties);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public String getValue(String propertyName) {
        return this.properties.getOrDefault(propertyName, this.wildcards.get(new PropertyName(propertyName)));
    }

    void addDefaults(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.addDefault(entry.getKey(), entry.getValue());
        }
    }

    void addDefault(String name, String value) {
        if (name.indexOf(42) == -1) {
            this.properties.putIfAbsent(name, value);
        } else {
            this.wildcards.putIfAbsent(new PropertyName(name), value);
        }
    }
}

