/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.ConfigMapping;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingInterface;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingLoader;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingNames;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigValidationException;
import io.cryostat.agent.shaded.io.smallrye.config.SmallRyeConfig;
import io.cryostat.agent.shaded.io.smallrye.config.SmallRyeConfigBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ConfigMappings {
    public static void registerConfigMappings(SmallRyeConfig config, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, new SmallRyeConfigBuilder(), configClasses);
        }
    }

    public static void registerConfigProperties(SmallRyeConfig config, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, new SmallRyeConfigBuilder().withValidateUnknown(false), configClasses);
        }
    }

    public static Map<String, ConfigMappingInterface.Property> getProperties(ConfigClassWithPrefix configClass) {
        HashMap<String, ConfigMappingInterface.Property> properties = new HashMap<String, ConfigMappingInterface.Property>();
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : ConfigMappingInterface.getProperties(ConfigMappingLoader.getConfigMapping(configClass.getKlass())).get(configClass.getKlass()).get("").entrySet()) {
            properties.put(ConfigMappings.prefix(configClass.getPrefix(), entry.getKey()), entry.getValue());
        }
        return properties;
    }

    @Deprecated
    public static Set<String> mappedProperties(ConfigClassWithPrefix configClass, Set<String> properties) {
        ConfigMappingNames names = new ConfigMappingNames(ConfigMappingLoader.getConfigMapping(configClass.getKlass()).getNames());
        HashSet<String> mappedNames = new HashSet<String>();
        for (String property : properties) {
            if (!names.hasAnyName(configClass.getKlass().getName(), configClass.getPrefix(), configClass.getPrefix(), Set.of(property))) continue;
            mappedNames.add(property);
        }
        return mappedNames;
    }

    private static void mapConfiguration(SmallRyeConfig config, SmallRyeConfigBuilder configBuilder, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        for (ConfigClassWithPrefix configClass : configClasses) {
            configBuilder.withMapping(configClass.getKlass(), configClass.getPrefix());
        }
        config.getDefaultValues().addDefaults(configBuilder.getDefaultValues());
        config.getMappings().putAll(config.buildMappings(configBuilder));
    }

    static String prefix(String prefix, String path) {
        if (prefix.isEmpty()) {
            return path;
        }
        if (path.isEmpty()) {
            return prefix;
        }
        if (path.charAt(0) == '[') {
            return prefix + path;
        }
        return prefix + "." + path;
    }

    static String getPrefix(Class<?> type) {
        ConfigMapping configMapping = type.getAnnotation(ConfigMapping.class);
        return configMapping != null ? configMapping.prefix() : "";
    }

    public static final class ConfigClassWithPrefix {
        private final Class<?> klass;
        private final String prefix;

        public ConfigClassWithPrefix(Class<?> klass, String prefix) {
            this.klass = klass;
            this.prefix = prefix;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigClassWithPrefix that = (ConfigClassWithPrefix)o;
            return this.klass.equals(that.klass) && this.prefix.equals(that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.klass, this.prefix);
        }

        public static ConfigClassWithPrefix configClassWithPrefix(Class<?> klass, String prefix) {
            return new ConfigClassWithPrefix(klass, prefix);
        }

        public static ConfigClassWithPrefix configClassWithPrefix(Class<?> klass) {
            return ConfigClassWithPrefix.configClassWithPrefix(klass, ConfigMappings.getPrefix(klass));
        }
    }
}

