/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.ConfigMapping;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingClass;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingContext;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingInterface;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingMetadata;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingObject;
import io.cryostat.agent.shaded.io.smallrye.config._private.ConfigMessages;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.inject.ConfigProperties;
import io.smallrye.common.classloader.ClassDefiner;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ConfigMappingLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ConcurrentHashMap<String, Object> classLoaderLocks = new ConcurrentHashMap();
    private static final ClassValue<ConfigMappingObjectHolder> CACHE = new ClassValue<ConfigMappingObjectHolder>(){

        @Override
        protected ConfigMappingObjectHolder computeValue(Class<?> type) {
            return new ConfigMappingObjectHolder(ConfigMappingLoader.getImplementationClass(type));
        }
    };

    public static List<ConfigMappingMetadata> getConfigMappingsMetadata(Class<?> type) {
        ConfigMappingClass configMappingClass;
        ArrayList<ConfigMappingMetadata> mappings = new ArrayList<ConfigMappingMetadata>();
        ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(type);
        if (configurationInterface != null) {
            mappings.add(configurationInterface);
            mappings.addAll(configurationInterface.getNested());
            for (ConfigMappingInterface superType : configurationInterface.getSuperTypes()) {
                mappings.add(superType);
                mappings.addAll(superType.getNested());
            }
        }
        if ((configMappingClass = ConfigMappingClass.getConfigurationClass(type)) != null) {
            mappings.add(configMappingClass);
            mappings.addAll(ConfigMappingLoader.getConfigMappingsMetadata(ConfigMappingLoader.getConfigMapping(type).getInterfaceType()));
        }
        return List.copyOf(mappings);
    }

    public static ConfigMappingInterface getConfigMapping(Class<?> type) {
        return ConfigMappingInterface.getConfigurationInterface(ConfigMappingLoader.getConfigMappingClass(type));
    }

    static Class<?> getConfigMappingClass(Class<?> type) {
        ConfigMappingLoader.validateAnnotations(type);
        ConfigMappingClass configMappingClass = ConfigMappingClass.getConfigurationClass(type);
        if (configMappingClass == null) {
            return type;
        }
        return ConfigMappingLoader.loadClass(type, configMappingClass);
    }

    static <T> Map<String, Map<String, Set<String>>> configMappingNames(Class<T> interfaceType) {
        try {
            Method getNames = CACHE.get(interfaceType).getImplementationClass().getDeclaredMethod("getNames", new Class[0]);
            return (Map)getNames.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }

    static <T> Map<String, String> configMappingDefaults(Class<T> interfaceType) {
        try {
            Method getDefaults = CACHE.get(interfaceType).getImplementationClass().getDeclaredMethod("getDefaults", new Class[0]);
            return (Map)getDefaults.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }

    static <T> T configMappingObject(Class<T> interfaceType, ConfigMappingContext configMappingContext) {
        ConfigMappingObject instance;
        try {
            Constructor<? extends ConfigMappingObject> constructor = CACHE.get(interfaceType).getImplementationClass().getDeclaredConstructor(ConfigMappingContext.class);
            instance = constructor.newInstance(configMappingContext);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return interfaceType.cast(instance);
    }

    public static <T> Class<? extends ConfigMappingObject> getImplementationClass(Class<T> type) {
        try {
            Class<?> implementationClass = type.getClassLoader().loadClass(type.getName() + type.getName().hashCode() + "Impl");
            if (type.isAssignableFrom(implementationClass)) {
                return implementationClass;
            }
            ConfigMappingInterface mappingMetadata = ConfigMappingInterface.getConfigurationInterface(type);
            if (mappingMetadata == null) {
                throw ConfigMessages.msg.classIsNotAMapping(type);
            }
            return ConfigMappingLoader.loadClass(type, mappingMetadata);
        }
        catch (ClassNotFoundException e) {
            ConfigMappingInterface mappingMetadata = ConfigMappingInterface.getConfigurationInterface(type);
            if (mappingMetadata == null) {
                throw ConfigMessages.msg.classIsNotAMapping(type);
            }
            return ConfigMappingLoader.loadClass(type, mappingMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> loadClass(Class<?> parent, ConfigMappingMetadata configMappingMetadata) {
        Object object = ConfigMappingLoader.getClassLoaderLock(configMappingMetadata.getClassName());
        synchronized (object) {
            try {
                Class<?> klass = parent.getClassLoader().loadClass(configMappingMetadata.getClassName());
                if (parent.isAssignableFrom(klass)) {
                    return klass;
                }
                if (configMappingMetadata instanceof ConfigMappingClass) {
                    return klass;
                }
                return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
            }
            catch (ClassNotFoundException e) {
                return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
            }
        }
    }

    static void validateAnnotations(Class<?> type) {
        if (!type.isInterface() && type.isAnnotationPresent(ConfigMapping.class)) {
            throw ConfigMessages.msg.mappingAnnotationNotSupportedInClass(type);
        }
        if (type.isInterface() && type.isAnnotationPresent(ConfigProperties.class)) {
            throw ConfigMessages.msg.propertiesAnnotationNotSupportedInInterface(type);
        }
    }

    private static Class<?> defineClass(Class<?> parent, String className, byte[] classBytes) {
        return ClassDefiner.defineClass(LOOKUP, parent, className, classBytes);
    }

    private static Object getClassLoaderLock(String className) {
        return classLoaderLocks.computeIfAbsent(className, c -> new Object());
    }

    private static final class ConfigMappingObjectHolder {
        private final Class<? extends ConfigMappingObject> implementationClass;

        ConfigMappingObjectHolder(Class<? extends ConfigMappingObject> implementationClass) {
            this.implementationClass = implementationClass;
        }

        public Class<? extends ConfigMappingObject> getImplementationClass() {
            return this.implementationClass;
        }
    }
}

