/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.ConfigMapping;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingGenerator;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingMetadata;
import io.cryostat.agent.shaded.io.smallrye.config.WithConverter;
import io.cryostat.agent.shaded.io.smallrye.config.WithDefault;
import io.cryostat.agent.shaded.io.smallrye.config.WithDefaults;
import io.cryostat.agent.shaded.io.smallrye.config.WithName;
import io.cryostat.agent.shaded.io.smallrye.config.WithParentName;
import io.cryostat.agent.shaded.io.smallrye.config.WithUnnamedKey;
import io.cryostat.agent.shaded.io.smallrye.config._private.ConfigMessages;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.spi.Converter;
import io.smallrye.common.constraint.Assert;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ConfigMappingInterface
implements ConfigMappingMetadata {
    static final ConfigMappingInterface[] NO_TYPES = new ConfigMappingInterface[0];
    static final Property[] NO_PROPERTIES = new Property[0];
    static final ClassValue<ConfigMappingInterface> cv = new ClassValue<ConfigMappingInterface>(){

        @Override
        protected ConfigMappingInterface computeValue(Class<?> type) {
            return ConfigMappingInterface.createConfigurationInterface(type);
        }
    };
    private final Class<?> interfaceType;
    private final String className;
    private final ConfigMappingInterface[] superTypes;
    private final Property[] properties;
    private final ToStringMethod toStringMethod;

    ConfigMappingInterface(Class<?> interfaceType, ConfigMappingInterface[] superTypes, Property[] properties) {
        this.interfaceType = interfaceType;
        this.className = interfaceType.getName() + interfaceType.getName().hashCode() + "Impl";
        this.superTypes = superTypes;
        ArrayList<Property> filteredProperties = new ArrayList<Property>();
        ToStringMethod toStringMethod = null;
        for (Property property : properties) {
            if (!property.isToStringMethod()) {
                filteredProperties.add(property);
                continue;
            }
            toStringMethod = (ToStringMethod)property;
        }
        if (toStringMethod == null) {
            toStringMethod = ToStringMethod.NONE;
        }
        this.properties = filteredProperties.toArray(new Property[0]);
        this.toStringMethod = toStringMethod;
    }

    public static ConfigMappingInterface getConfigurationInterface(Class<?> interfaceType) {
        Assert.checkNotNullParam("interfaceType", interfaceType);
        return cv.get(interfaceType);
    }

    @Override
    public Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public ConfigMappingInterface[] getSuperTypes() {
        return this.superTypes;
    }

    public Property[] getProperties() {
        Map<String, Property> properties = ConfigMappingInterface.getSuperProperties(this);
        for (Property property : this.properties) {
            properties.put(property.getMemberName(), property);
        }
        return properties.values().toArray(new Property[0]);
    }

    public Map<String, Map<String, Set<String>>> getNames() {
        return ConfigMappingInterface.getNames(this);
    }

    private static Map<String, Property> getSuperProperties(ConfigMappingInterface type) {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (ConfigMappingInterface superType : type.getSuperTypes()) {
            properties.putAll(ConfigMappingInterface.getSuperProperties(superType));
            for (Property property : superType.getProperties()) {
                properties.put(property.getMemberName(), property);
            }
        }
        return properties;
    }

    public boolean hasNamingStrategy() {
        return this.interfaceType.getAnnotation(ConfigMapping.class) != null;
    }

    public ConfigMapping.NamingStrategy getNamingStrategy() {
        ConfigMapping configMapping = this.interfaceType.getAnnotation(ConfigMapping.class);
        return configMapping != null ? configMapping.namingStrategy() : ConfigMapping.NamingStrategy.KEBAB_CASE;
    }

    ToStringMethod getToStringMethod() {
        return this.toStringMethod;
    }

    String getClassInternalName() {
        return this.className.replace('.', '/');
    }

    List<ConfigMappingInterface> getNested() {
        LinkedHashSet<ConfigMappingInterface> nested = new LinkedHashSet<ConfigMappingInterface>();
        ConfigMappingInterface.getNested(this.properties, nested);
        return new ArrayList<ConfigMappingInterface>(nested);
    }

    @Override
    public byte[] getClassBytes() {
        try {
            return ConfigMappingGenerator.generate(this);
        }
        catch (Throwable e) {
            throw ConfigMessages.msg.couldNotGenerateMapping(e);
        }
    }

    private static ConfigMappingInterface createConfigurationInterface(Class<?> interfaceType) {
        if (!interfaceType.isInterface() || interfaceType.getTypeParameters().length != 0) {
            return null;
        }
        if (interfaceType.getName().startsWith("java")) {
            return null;
        }
        ConfigMappingInterface[] superTypes = ConfigMappingInterface.getSuperTypes(interfaceType.getInterfaces(), 0, 0);
        Property[] properties = ConfigMappingInterface.getProperties(interfaceType.getDeclaredMethods(), 0, 0);
        return new ConfigMappingInterface(interfaceType, superTypes, properties);
    }

    private static ConfigMappingInterface[] getSuperTypes(Class<?>[] interfaces, int si, int ti) {
        if (si == interfaces.length) {
            if (ti == 0) {
                return NO_TYPES;
            }
            return new ConfigMappingInterface[ti];
        }
        Class<?> item = interfaces[si];
        ConfigMappingInterface ci = ConfigMappingInterface.getConfigurationInterface(item);
        if (ci != null) {
            ConfigMappingInterface[] array = ConfigMappingInterface.getSuperTypes(interfaces, si + 1, ti + 1);
            array[ti] = ci;
            return array;
        }
        return ConfigMappingInterface.getSuperTypes(interfaces, si + 1, ti);
    }

    static Property[] getProperties(Method[] methods, int si, int ti) {
        for (int i = si; i < methods.length; ++i) {
            Method method = methods[i];
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || !Modifier.isAbstract(mods)) continue;
            if (method.getParameterCount() > 0) {
                throw new IllegalArgumentException("Configuration methods cannot accept parameters: " + method);
            }
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Void config methods are not allowed: " + method);
            }
            Property p = ConfigMappingInterface.getPropertyDef(method, method.getAnnotatedReturnType());
            Property[] array = i + 1 == methods.length ? new Property[ti + 1] : ConfigMappingInterface.getProperties(methods, i + 1, ti + 1);
            array[ti] = p;
            return array;
        }
        return ti > 0 ? new Property[ti] : NO_PROPERTIES;
    }

    private static Property getPropertyDef(Method method, AnnotatedType type) {
        if (ConfigMappingInterface.isToStringMethod(method)) {
            return new ToStringMethod(method);
        }
        Method defaultMethod = ConfigMappingInterface.hasDefaultMethodImplementation(method);
        if (defaultMethod != null) {
            return new DefaultMethodProperty(method, defaultMethod, ConfigMappingInterface.getPropertyDef(defaultMethod, type));
        }
        Class<? extends Converter<?>> convertWith = ConfigMappingInterface.getConverter(type, method);
        String propertyName = ConfigMappingInterface.getPropertyName(method);
        Class<?> rawType = ConfigMappingInterface.rawTypeOf(type.getType());
        if (rawType.isPrimitive()) {
            return new PrimitiveProperty(method, propertyName, rawType, convertWith, ConfigMappingInterface.getDefaultValue(method));
        }
        if (convertWith == null) {
            if (rawType == Optional.class) {
                Property nested = ConfigMappingInterface.getPropertyDef(method, ConfigMappingInterface.typeOfParameter(type, 0));
                if (nested.isMayBeOptional()) {
                    return new OptionalProperty(method, propertyName, nested.asMayBeOptional());
                }
                throw new IllegalArgumentException("Property type " + type + " cannot be optional");
            }
            if (rawType == Map.class) {
                AnnotatedType keyType = ConfigMappingInterface.typeOfParameter(type, 0);
                AnnotatedType valueType = ConfigMappingInterface.typeOfParameter(type, 1);
                String defaultValue = ConfigMappingInterface.getDefaultValue(method);
                return new MapProperty(method, propertyName, keyType.getType(), ConfigMappingInterface.getUnnamedKey(keyType, method), ConfigMappingInterface.getConverter(keyType, method), ConfigMappingInterface.getPropertyDef(method, valueType), defaultValue != null || ConfigMappingInterface.hasDefaults(method), defaultValue);
            }
            if (rawType == List.class || rawType == Set.class) {
                AnnotatedType elementType = ConfigMappingInterface.typeOfParameter(type, 0);
                if (ConfigMappingInterface.rawTypeOf(elementType.getType()) == Map.class) {
                    return new CollectionProperty(rawType, ConfigMappingInterface.getPropertyDef(method, elementType));
                }
                ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(ConfigMappingInterface.rawTypeOf(elementType.getType()));
                if (configurationInterface != null) {
                    return new CollectionProperty(rawType, new GroupProperty(method, propertyName, configurationInterface));
                }
                Class<Converter<?>> converter = ConfigMappingInterface.getConverter(elementType, method);
                if (converter != null) {
                    convertWith = converter;
                }
                return new CollectionProperty(rawType, new LeafProperty(method, propertyName, elementType.getType(), convertWith, ConfigMappingInterface.getDefaultValue(method)));
            }
            ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(rawType);
            if (configurationInterface != null) {
                return new GroupProperty(method, propertyName, configurationInterface);
            }
        }
        String defaultValue = ConfigMappingInterface.getDefaultValue(method);
        if (rawType == List.class || rawType == Set.class) {
            AnnotatedType elementType = ConfigMappingInterface.typeOfParameter(type, 0);
            Class<Converter<?>> converter = ConfigMappingInterface.getConverter(elementType, method);
            if (converter != null) {
                convertWith = converter;
            }
            return new CollectionProperty(rawType, new LeafProperty(method, propertyName, elementType.getType(), convertWith, defaultValue));
        }
        if (rawType == Optional.class) {
            return new OptionalProperty(method, propertyName, new LeafProperty(method, propertyName, type.getType(), convertWith, defaultValue));
        }
        return new LeafProperty(method, propertyName, type.getType(), convertWith, defaultValue);
    }

    private static boolean isToStringMethod(Method method) {
        return method.getName().equals("toString") && method.getParameterCount() == 0 && method.getReturnType().equals(String.class) && !method.isDefault();
    }

    private static Method hasDefaultMethodImplementation(Method method) {
        Class<?>[] memberClasses;
        Class<?> methodClass = method.getDeclaringClass();
        for (Class<?> memberClass : memberClasses = methodClass.getClasses()) {
            Method candidateMethod;
            if (!memberClass.getSimpleName().equals("DefaultImpls")) continue;
            try {
                candidateMethod = memberClass.getMethod(method.getName(), methodClass);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (!candidateMethod.getReturnType().equals(method.getReturnType())) continue;
            return candidateMethod;
        }
        return null;
    }

    private static String getDefaultValue(Method method) {
        WithDefault annotation = method.getAnnotation(WithDefault.class);
        return annotation == null ? null : annotation.value();
    }

    private static boolean hasDefaults(Method method) {
        return method.getAnnotation(WithDefaults.class) != null;
    }

    private static String getUnnamedKey(AnnotatedType type, Method method) {
        WithUnnamedKey annotation = type.getAnnotation(WithUnnamedKey.class);
        if (annotation == null) {
            annotation = method.getAnnotation(WithUnnamedKey.class);
        }
        return annotation != null ? annotation.value() : null;
    }

    private static Class<? extends Converter<?>> getConverter(AnnotatedType type, Method method) {
        WithConverter annotation = type.getAnnotation(WithConverter.class);
        if (annotation == null) {
            annotation = method.getAnnotation(WithConverter.class);
        }
        if (annotation != null) {
            Class<? extends Converter<?>> value = annotation.value();
            ConfigMappingInterface.validateConverter(type.getType(), value);
            return value;
        }
        return null;
    }

    private static void validateConverter(Type type, Class<? extends Converter<?>> convertWith) {
        if (type instanceof Class) {
            try {
                Class<?> classType = (Class<?>)type;
                Class<?> effectiveType = classType.isPrimitive() ? PrimitiveProperty.boxTypes.get(classType) : classType;
                Method convertMethod = convertWith.getMethod("convert", String.class);
                if (!effectiveType.isAssignableFrom(convertMethod.getReturnType())) {
                    throw new IllegalArgumentException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private static String getPropertyName(AnnotatedElement element) {
        boolean useParent = element.getAnnotation(WithParentName.class) != null;
        WithName annotation = element.getAnnotation(WithName.class);
        if (annotation != null) {
            if (useParent) {
                throw new IllegalArgumentException("Cannot specify both @WithParentName and @WithName in '" + element + "'");
            }
            String name = annotation.value();
            if (!name.isEmpty()) {
                return name;
            }
            throw new IllegalArgumentException("Property name is empty");
        }
        if (useParent) {
            return "";
        }
        return null;
    }

    private static void getNested(Property[] properties, Set<ConfigMappingInterface> nested) {
        for (Property property : properties) {
            if (property instanceof GroupProperty) {
                GroupProperty groupProperty = (GroupProperty)property;
                ConfigMappingInterface group = groupProperty.getGroupType();
                nested.add(group);
                Collections.addAll(nested, group.superTypes);
                ConfigMappingInterface.getNested(group.getProperties(), nested);
            }
            if (property instanceof OptionalProperty) {
                OptionalProperty optionalProperty = (OptionalProperty)property;
                if (optionalProperty.getNestedProperty() instanceof GroupProperty) {
                    GroupProperty groupProperty = (GroupProperty)optionalProperty.getNestedProperty();
                    ConfigMappingInterface group = groupProperty.getGroupType();
                    nested.add(group);
                    Collections.addAll(nested, group.superTypes);
                    ConfigMappingInterface.getNested(group.getProperties(), nested);
                } else if (optionalProperty.getNestedProperty() instanceof CollectionProperty) {
                    CollectionProperty collectionProperty = (CollectionProperty)optionalProperty.getNestedProperty();
                    ConfigMappingInterface.getNested(new Property[]{collectionProperty.element}, nested);
                }
            }
            if (property instanceof MapProperty) {
                MapProperty mapProperty = (MapProperty)property;
                ConfigMappingInterface.getNested(new Property[]{mapProperty.valueProperty}, nested);
            }
            if (!(property instanceof CollectionProperty)) continue;
            CollectionProperty collectionProperty = (CollectionProperty)property;
            ConfigMappingInterface.getNested(new Property[]{collectionProperty.element}, nested);
        }
    }

    static AnnotatedType typeOfParameter(AnnotatedType type, int index) {
        if (type instanceof AnnotatedParameterizedType) {
            return ((AnnotatedParameterizedType)type).getAnnotatedActualTypeArguments()[index];
        }
        return type;
    }

    static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigMappingInterface.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigMappingInterface.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds != null) {
                return ConfigMappingInterface.rawTypeOf(upperBounds[0]);
            }
            return Object.class;
        }
        throw ConfigMessages.msg.noRawType(type);
    }

    public static Map<String, Map<String, Set<String>>> getNames(ConfigMappingInterface configMapping) {
        HashMap<String, Map<String, Set<String>>> names = new HashMap<String, Map<String, Set<String>>>();
        Map<Class<?>, Map<String, Map<String, Property>>> properties = ConfigMappingInterface.getProperties(configMapping);
        for (Map.Entry<Class<?>, Map<String, Map<String, Property>>> entry : properties.entrySet()) {
            HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
            for (Map.Entry<String, Map<String, Property>> group : entry.getValue().entrySet()) {
                groups.put(group.getKey(), group.getValue().keySet());
            }
            names.put(entry.getKey().getName(), groups);
        }
        return names;
    }

    public static Map<Class<?>, Map<String, Map<String, Property>>> getProperties(ConfigMappingInterface configMapping) {
        HashMap properties = new HashMap();
        ConfigMappingInterface.getProperties(new GroupProperty(null, null, configMapping), configMapping.getNamingStrategy(), new Path(), properties);
        return properties;
    }

    private static void getProperties(GroupProperty groupProperty, ConfigMapping.NamingStrategy namingStrategy, Path path, Map<Class<?>, Map<String, Map<String, Property>>> properties) {
        ConfigMappingInterface groupType = groupProperty.getGroupType();
        Map groupProperties = properties.computeIfAbsent(groupType.getInterfaceType(), group -> new HashMap()).computeIfAbsent(path.get(), s -> new HashMap());
        ConfigMappingInterface.getProperties(groupProperty, namingStrategy, path, properties, groupProperties);
    }

    private static void getProperties(GroupProperty groupProperty, ConfigMapping.NamingStrategy namingStrategy, Path path, Map<Class<?>, Map<String, Map<String, Property>>> properties, Map<String, Property> groupProperties) {
        for (Property property : groupProperty.getGroupType().getProperties()) {
            ConfigMappingInterface.getProperty(property, namingStrategy, path, properties, groupProperties);
        }
    }

    private static void getProperty(Property property, ConfigMapping.NamingStrategy namingStrategy, Path path, Map<Class<?>, Map<String, Map<String, Property>>> properties, Map<String, Property> groupProperties) {
        if (property.isLeaf() || property.isPrimitive()) {
            groupProperties.put(path.get(property, namingStrategy), property);
        } else if (property.isGroup()) {
            GroupProperty groupProperty = property.asGroup();
            ConfigMapping.NamingStrategy groupNamingStrategy = groupProperty.hasNamingStrategy() ? groupProperty.getNamingStrategy() : namingStrategy;
            Path groupPath = path.group(groupProperty, namingStrategy);
            ConfigMappingInterface.getProperties(groupProperty, groupNamingStrategy, groupPath, properties);
            ConfigMappingInterface.getProperties(groupProperty, groupNamingStrategy, groupPath, properties, groupProperties);
        } else if (property.isMap()) {
            MapProperty mapProperty = property.asMap();
            if (mapProperty.getValueProperty().isLeaf()) {
                groupProperties.put(path.map(property, namingStrategy).get(), property);
                if (mapProperty.hasKeyUnnamed()) {
                    groupProperties.put(path.unnamedMap(property, namingStrategy).get(), property);
                }
            } else if (mapProperty.getValueProperty().isGroup()) {
                GroupProperty groupProperty = mapProperty.getValueProperty().asGroup();
                ConfigMapping.NamingStrategy groupNamingStrategy = groupProperty.hasNamingStrategy() ? groupProperty.getNamingStrategy() : namingStrategy;
                Path mapPath = path.map(mapProperty, namingStrategy);
                ConfigMappingInterface.getProperties(groupProperty, groupNamingStrategy, mapPath, properties);
                ConfigMappingInterface.getProperties(groupProperty, groupNamingStrategy, mapPath, properties, groupProperties);
                if (mapProperty.hasKeyUnnamed()) {
                    Path unnamedMapPath = path.unnamedMap(mapProperty, namingStrategy);
                    ConfigMappingInterface.getProperties(groupProperty, groupNamingStrategy, unnamedMapPath, properties);
                    ConfigMappingInterface.getProperties(groupProperty, groupNamingStrategy, unnamedMapPath, properties, groupProperties);
                }
            } else if (mapProperty.getValueProperty().isCollection()) {
                CollectionProperty collectionProperty = mapProperty.getValueProperty().asCollection();
                Property element = collectionProperty.getElement();
                if (element.isLeaf()) {
                    groupProperties.put(path.map().collection().get(property, namingStrategy), property);
                    groupProperties.put(path.map().get(property, namingStrategy), new LeafProperty(element.getMethod(), element.getPropertyName(), element.asLeaf().getValueType(), element.asLeaf().getConvertWith(), null));
                    if (mapProperty.hasKeyUnnamed()) {
                        groupProperties.put(path.collection().get(property, namingStrategy), property);
                    }
                } else {
                    ConfigMappingInterface.getProperty(element, namingStrategy, path.map().collection(), properties, groupProperties);
                    if (mapProperty.hasKeyUnnamed()) {
                        ConfigMappingInterface.getProperty(element, namingStrategy, path.collection(), properties, groupProperties);
                    }
                }
            } else if (mapProperty.getValueProperty().isMap()) {
                ConfigMappingInterface.getProperty(mapProperty.getValueProperty(), namingStrategy, path.map(), properties, groupProperties);
                if (mapProperty.hasKeyUnnamed()) {
                    ConfigMappingInterface.getProperty(mapProperty.getValueProperty(), namingStrategy, path.unnamedMap(), properties, groupProperties);
                }
            }
        } else if (property.isCollection()) {
            CollectionProperty collectionProperty = property.asCollection();
            if (collectionProperty.getElement().isLeaf()) {
                ConfigMappingInterface.getProperty(collectionProperty.getElement(), namingStrategy, path, properties, groupProperties);
            }
            ConfigMappingInterface.getProperty(collectionProperty.getElement(), namingStrategy, path.collection(), properties, groupProperties);
        } else if (property.isOptional()) {
            ConfigMappingInterface.getProperty(property.asOptional().getNestedProperty(), namingStrategy, path, properties, groupProperties);
        }
    }

    static class Path {
        private final String path;
        private final List<String> elements;

        Path() {
            this("");
        }

        Path(String path) {
            this(path, new ArrayList<String>());
        }

        Path(String path, List<String> elements) {
            this.path = path;
            this.elements = elements;
        }

        Path group(String path) {
            return new Path(this.get(path));
        }

        Path group(Property property, ConfigMapping.NamingStrategy namingStrategy) {
            if (property.isParentPropertyName()) {
                return this.group("");
            }
            return this.group(property.getPropertyName(namingStrategy));
        }

        Path map() {
            ArrayList<String> elements = new ArrayList<String>(this.elements);
            elements.add(this.path.isEmpty() && elements.isEmpty() ? "*" : ".*");
            return new Path(this.get(), elements);
        }

        Path map(String path) {
            return new Path(this.get(path));
        }

        Path map(Property property, ConfigMapping.NamingStrategy namingStrategy) {
            if (property.isParentPropertyName()) {
                this.elements.add(this.path.isEmpty() && this.elements.isEmpty() ? "*" : ".*");
                return this.map("");
            }
            this.elements.add(".*");
            return this.map(property.getPropertyName(namingStrategy));
        }

        Path collection() {
            ArrayList<String> elements = new ArrayList<String>(this.elements);
            elements.add("[*]");
            return new Path(this.get(), elements);
        }

        Path unnamedMap() {
            return this;
        }

        Path unnamedMap(String path) {
            return new Path(this.get(path));
        }

        Path unnamedMap(Property property, ConfigMapping.NamingStrategy namingStrategy) {
            return this.unnamedMap(property.isParentPropertyName() ? "" : property.getPropertyName(namingStrategy));
        }

        String get(String path) {
            String elements = String.join((CharSequence)"", this.elements);
            this.elements.clear();
            if (this.path.isEmpty()) {
                if (path.isEmpty()) {
                    return elements;
                }
                if (!elements.isEmpty() && elements.charAt(0) == '*') {
                    return path + "." + elements;
                }
                return path + elements;
            }
            return path.isEmpty() ? this.path + elements : this.path + "." + path + elements;
        }

        String get(Property property, ConfigMapping.NamingStrategy namingStrategy) {
            return this.get(property.isParentPropertyName() ? "" : property.getPropertyName(namingStrategy));
        }

        String get() {
            return this.path;
        }
    }

    public static final class ToStringMethod
    extends Property {
        private final boolean generate;
        static final ToStringMethod NONE = new ToStringMethod();

        ToStringMethod() {
            super(null, null);
            this.generate = false;
        }

        ToStringMethod(Method method) {
            super(method, null);
            this.generate = true;
        }

        @Override
        public boolean isToStringMethod() {
            return true;
        }

        public boolean generate() {
            return this.generate;
        }
    }

    public static final class DefaultMethodProperty
    extends Property {
        private final Method defaultMethod;
        private final Property defaultProperty;

        DefaultMethodProperty(Method method, Method defaultMethod, Property defaultProperty) {
            super(method, "");
            this.defaultMethod = defaultMethod;
            this.defaultProperty = defaultProperty;
        }

        public Method getDefaultMethod() {
            return this.defaultMethod;
        }

        public Property getDefaultProperty() {
            return this.defaultProperty;
        }

        @Override
        public boolean isDefaultMethod() {
            return true;
        }

        @Override
        public DefaultMethodProperty asDefaultMethod() {
            return this;
        }
    }

    public static final class CollectionProperty
    extends MayBeOptionalProperty {
        private final Class<?> collectionRawType;
        private final Property element;

        CollectionProperty(Class<?> collectionType, Property element) {
            super(element.getMethod(), element.hasPropertyName() ? element.getPropertyName() : null);
            this.collectionRawType = collectionType;
            this.element = element;
        }

        public Class<?> getCollectionRawType() {
            return this.collectionRawType;
        }

        public Property getElement() {
            return this.element;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public CollectionProperty asCollection() {
            return this;
        }
    }

    public static final class MapProperty
    extends Property {
        private final Type keyType;
        private final String keyUnnamed;
        private final Class<? extends Converter<?>> keyConvertWith;
        private final Property valueProperty;
        private final boolean hasDefault;
        private final String defaultValue;

        MapProperty(Method method, String propertyName, Type keyType, String keyUnnamed, Class<? extends Converter<?>> keyConvertWith, Property valueProperty, boolean hasDefault, String defaultValue) {
            super(method, propertyName);
            this.keyType = keyType;
            this.keyUnnamed = keyUnnamed;
            this.keyConvertWith = keyConvertWith;
            this.valueProperty = valueProperty;
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
        }

        public Type getKeyType() {
            return this.keyType;
        }

        public Class<?> getKeyRawType() {
            return ConfigMappingInterface.rawTypeOf(this.keyType);
        }

        public String getKeyUnnamed() {
            return this.keyUnnamed;
        }

        public boolean hasKeyUnnamed() {
            return this.keyUnnamed != null;
        }

        public Class<? extends Converter<?>> getKeyConvertWith() {
            return Assert.checkNotNullParam("keyConvertWith", this.keyConvertWith);
        }

        public boolean hasKeyConvertWith() {
            return this.keyConvertWith != null;
        }

        public Property getValueProperty() {
            return this.valueProperty;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.hasDefault;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public MapProperty asMap() {
            return this;
        }
    }

    public static final class LeafProperty
    extends MayBeOptionalProperty {
        private final Type valueType;
        private final Class<? extends Converter<?>> convertWith;
        private final Class<?> rawType;
        private final String defaultValue;

        LeafProperty(Method method, String propertyName, Type valueType, Class<? extends Converter<?>> convertWith, String defaultValue) {
            super(method, propertyName);
            this.valueType = valueType;
            this.convertWith = convertWith;
            this.rawType = ConfigMappingInterface.rawTypeOf(valueType);
            this.defaultValue = defaultValue;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public Class<? extends Converter<?>> getConvertWith() {
            return this.convertWith;
        }

        @Override
        public boolean hasConvertWith() {
            return this.convertWith != null;
        }

        @Override
        public String getDefaultValue() {
            return Assert.checkNotNullParam("defaultValue", this.defaultValue);
        }

        @Override
        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public Class<?> getValueRawType() {
            return this.rawType;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public LeafProperty asLeaf() {
            return this;
        }
    }

    public static final class GroupProperty
    extends MayBeOptionalProperty {
        private final ConfigMappingInterface groupType;

        GroupProperty(Method method, String propertyName, ConfigMappingInterface groupType) {
            super(method, propertyName);
            this.groupType = groupType;
        }

        public ConfigMappingInterface getGroupType() {
            return this.groupType;
        }

        @Override
        public boolean isGroup() {
            return true;
        }

        @Override
        public GroupProperty asGroup() {
            return this;
        }

        public boolean hasNamingStrategy() {
            return this.groupType.getInterfaceType().isAnnotationPresent(ConfigMapping.class);
        }

        public ConfigMapping.NamingStrategy getNamingStrategy() {
            return this.groupType.getNamingStrategy();
        }
    }

    public static final class OptionalProperty
    extends Property {
        private final MayBeOptionalProperty nestedProperty;

        OptionalProperty(Method method, String propertyName, MayBeOptionalProperty nestedProperty) {
            super(method, propertyName);
            this.nestedProperty = nestedProperty;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public OptionalProperty asOptional() {
            return this;
        }

        @Override
        public boolean isLeaf() {
            return this.nestedProperty.isLeaf();
        }

        @Override
        public LeafProperty asLeaf() {
            return this.isLeaf() ? this.nestedProperty.asLeaf() : super.asLeaf();
        }

        @Override
        public boolean hasDefaultValue() {
            return this.isLeaf() && this.nestedProperty.asLeaf().hasDefaultValue();
        }

        @Override
        public String getDefaultValue() {
            return this.hasDefaultValue() ? this.nestedProperty.asLeaf().getDefaultValue() : null;
        }

        public MayBeOptionalProperty getNestedProperty() {
            return this.nestedProperty;
        }
    }

    public static final class PrimitiveProperty
    extends Property {
        private static final Map<Class<?>, Class<?>> boxTypes;
        private static final Map<Class<?>, String> unboxMethodName;
        private static final Map<Class<?>, String> unboxMethodDesc;
        private final Class<?> primitiveType;
        private final Class<? extends Converter<?>> convertWith;
        private final String defaultValue;

        PrimitiveProperty(Method method, String propertyName, Class<?> primitiveType, Class<? extends Converter<?>> convertWith, String defaultValue) {
            super(method, propertyName);
            this.primitiveType = primitiveType;
            this.convertWith = convertWith;
            this.defaultValue = defaultValue;
        }

        public Class<?> getPrimitiveType() {
            return this.primitiveType;
        }

        public Class<?> getBoxType() {
            return boxTypes.get(this.primitiveType);
        }

        public Class<? extends Converter<?>> getConvertWith() {
            return Assert.checkNotNullParam("convertWith", this.convertWith);
        }

        @Override
        public boolean hasConvertWith() {
            return this.convertWith != null;
        }

        @Override
        public String getDefaultValue() {
            return Assert.checkNotNullParam("defaultValue", this.defaultValue);
        }

        @Override
        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public PrimitiveProperty asPrimitive() {
            return this;
        }

        String getUnboxMethodName() {
            return unboxMethodName.get(this.primitiveType);
        }

        String getUnboxMethodDescriptor() {
            return unboxMethodDesc.get(this.primitiveType);
        }

        static {
            HashMap map = new HashMap();
            map.put(Byte.TYPE, Byte.class);
            map.put(Short.TYPE, Short.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Float.TYPE, Float.class);
            map.put(Double.TYPE, Double.class);
            map.put(Boolean.TYPE, Boolean.class);
            map.put(Character.TYPE, Character.class);
            boxTypes = map;
            HashMap<Class<Object>, String> nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "byteValue");
            nameMap.put(Short.TYPE, "shortValue");
            nameMap.put(Integer.TYPE, "intValue");
            nameMap.put(Long.TYPE, "longValue");
            nameMap.put(Float.TYPE, "floatValue");
            nameMap.put(Double.TYPE, "doubleValue");
            nameMap.put(Boolean.TYPE, "booleanValue");
            nameMap.put(Character.TYPE, "charValue");
            unboxMethodName = nameMap;
            nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "()B");
            nameMap.put(Short.TYPE, "()S");
            nameMap.put(Integer.TYPE, "()I");
            nameMap.put(Long.TYPE, "()J");
            nameMap.put(Float.TYPE, "()F");
            nameMap.put(Double.TYPE, "()D");
            nameMap.put(Boolean.TYPE, "()Z");
            nameMap.put(Character.TYPE, "()C");
            unboxMethodDesc = nameMap;
            nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "B");
            nameMap.put(Short.TYPE, "S");
            nameMap.put(Integer.TYPE, "I");
            nameMap.put(Long.TYPE, "J");
            nameMap.put(Float.TYPE, "F");
            nameMap.put(Double.TYPE, "D");
            nameMap.put(Boolean.TYPE, "Z");
            nameMap.put(Character.TYPE, "C");
        }
    }

    public static abstract class MayBeOptionalProperty
    extends Property {
        MayBeOptionalProperty(Method method, String propertyName) {
            super(method, propertyName);
        }

        @Override
        public boolean isMayBeOptional() {
            return true;
        }

        @Override
        public MayBeOptionalProperty asMayBeOptional() {
            return this;
        }
    }

    public static abstract class Property {
        private final Method method;
        private final String propertyName;

        Property(Method method, String propertyName) {
            this.method = method;
            this.propertyName = propertyName;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getPropertyName() {
            if (this.isParentPropertyName()) {
                return this.propertyName;
            }
            return this.hasPropertyName() && !this.propertyName.isEmpty() ? this.propertyName : this.method.getName();
        }

        public String getPropertyName(ConfigMapping.NamingStrategy namingStrategy) {
            return this.hasPropertyName() ? this.getPropertyName() : namingStrategy.apply(this.getPropertyName());
        }

        public String getMemberName() {
            return this.method.getName();
        }

        public boolean hasPropertyName() {
            return this.propertyName != null;
        }

        public boolean hasConvertWith() {
            return false;
        }

        public boolean isParentPropertyName() {
            return this.hasPropertyName() && this.propertyName.isEmpty();
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public String getDefaultValue() {
            return null;
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isOptional() {
            return false;
        }

        public boolean isGroup() {
            return false;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean isMap() {
            return false;
        }

        public boolean isMayBeOptional() {
            return false;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isDefaultMethod() {
            return false;
        }

        public boolean isToStringMethod() {
            return false;
        }

        public PrimitiveProperty asPrimitive() {
            throw new ClassCastException();
        }

        public OptionalProperty asOptional() {
            throw new ClassCastException();
        }

        public GroupProperty asGroup() {
            throw new ClassCastException();
        }

        public LeafProperty asLeaf() {
            throw new ClassCastException();
        }

        public MapProperty asMap() {
            throw new ClassCastException();
        }

        public MayBeOptionalProperty asMayBeOptional() {
            throw new ClassCastException();
        }

        public CollectionProperty asCollection() {
            throw new ClassCastException();
        }

        public DefaultMethodProperty asDefaultMethod() {
            throw new ClassCastException();
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            boolean bl = result = this.method.equals(property.method) && this.propertyName.equals(property.propertyName);
            if (result) {
                return result;
            }
            return Property.isMethodInHierarchy(property.getMethod().getDeclaringClass(), this.method);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.propertyName);
        }

        private static boolean isMethodInHierarchy(Class<?> declaringClass, Method method) {
            for (Class<?> parent : declaringClass.getInterfaces()) {
                for (Method parentMethod : parent.getMethods()) {
                    if (!parentMethod.getName().equals(method.getName())) continue;
                    return true;
                }
                boolean methodInHierarchy = Property.isMethodInHierarchy(parent, method);
                if (!methodInHierarchy) continue;
                return true;
            }
            return false;
        }
    }
}

