/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.smallrye.config;

import io.cryostat.agent.shaded.io.smallrye.config.ConfigMapping;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingLoader;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingNames;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigMappingObject;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigValidationException;
import io.cryostat.agent.shaded.io.smallrye.config.ConfigValue;
import io.cryostat.agent.shaded.io.smallrye.config.Converters;
import io.cryostat.agent.shaded.io.smallrye.config.EnvConfigSource;
import io.cryostat.agent.shaded.io.smallrye.config.KeyMap;
import io.cryostat.agent.shaded.io.smallrye.config.NameIterator;
import io.cryostat.agent.shaded.io.smallrye.config.ProfileConfigSourceInterceptor;
import io.cryostat.agent.shaded.io.smallrye.config.PropertyName;
import io.cryostat.agent.shaded.io.smallrye.config.SmallRyeConfig;
import io.cryostat.agent.shaded.io.smallrye.config._private.ConfigMessages;
import io.cryostat.agent.shaded.io.smallrye.config.common.utils.StringUtil;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.spi.ConfigSource;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.spi.Converter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public final class ConfigMappingContext {
    private final SmallRyeConfig config;
    private final ConfigMappingNames names;
    private final Map<Class<?>, Map<String, ConfigMappingObject>> roots = new IdentityHashMap();
    private final Map<Class<?>, Converter<?>> converterInstances = new IdentityHashMap();
    private ConfigMapping.NamingStrategy namingStrategy;
    private String rootPath;
    private final StringBuilder nameBuilder = new StringBuilder();
    private final Set<String> usedProperties = new HashSet<String>();
    private final List<ConfigValidationException.Problem> problems = new ArrayList<ConfigValidationException.Problem>();

    public ConfigMappingContext(SmallRyeConfig config, final Map<Class<?>, Set<String>> roots) {
        this(config, (Map<String, Map<String, Set<String>>>)new Supplier<Map<String, Map<String, Set<String>>>>(){

            @Override
            public Map<String, Map<String, Set<String>>> get() {
                HashMap<String, Map<String, Set<String>>> names = new HashMap<String, Map<String, Set<String>>>();
                for (Map.Entry mapping : roots.entrySet()) {
                    for (Map.Entry<String, Map<String, Set<String>>> entry : ConfigMappingLoader.configMappingNames((Class)mapping.getKey()).entrySet()) {
                        names.putIfAbsent(entry.getKey(), new HashMap());
                        ((Map)names.get(entry.getKey())).putAll(entry.getValue());
                    }
                }
                return names;
            }
        }.get(), roots);
    }

    ConfigMappingContext(SmallRyeConfig config, Map<String, Map<String, Set<String>>> names, Map<Class<?>, Set<String>> roots) {
        this.config = config;
        this.names = new ConfigMappingNames(names);
        this.matchPropertiesWithEnv(roots);
        for (Map.Entry<Class<?>, Set<String>> mapping : roots.entrySet()) {
            HashMap<String, ConfigMappingObject> mappingObjects = new HashMap<String, ConfigMappingObject>();
            for (String rootPath : mapping.getValue()) {
                this.applyNamingStrategy(null);
                this.applyRootPath(rootPath);
                this.applyNameBuilder(rootPath);
                mappingObjects.put(rootPath, (ConfigMappingObject)this.constructRoot(mapping.getKey()));
            }
            this.roots.put(mapping.getKey(), mappingObjects);
        }
    }

    <T> T constructRoot(Class<T> interfaceType) {
        return this.constructGroup(interfaceType);
    }

    public <T> T constructGroup(Class<T> interfaceType) {
        ConfigMapping.NamingStrategy namingStrategy = this.namingStrategy;
        T mappingObject = ConfigMappingLoader.configMappingObject(interfaceType, this);
        this.namingStrategy = this.applyNamingStrategy(namingStrategy);
        return mappingObject;
    }

    public <T> ObjectCreator<T> constructObject(String path) {
        return new ObjectCreator(path);
    }

    public <T> Converter<T> getConverterInstance(Class<? extends Converter<? extends T>> converterType) {
        return this.converterInstances.computeIfAbsent(converterType, t -> {
            try {
                return (Converter)t.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable t2) {
                    throw new UndeclaredThrowableException(t2);
                }
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        });
    }

    public ConfigMapping.NamingStrategy applyNamingStrategy(ConfigMapping.NamingStrategy namingStrategy) {
        if (namingStrategy != null) {
            this.namingStrategy = namingStrategy;
        } else if (this.namingStrategy == null) {
            this.namingStrategy = ConfigMapping.NamingStrategy.KEBAB_CASE;
        }
        return this.namingStrategy;
    }

    public String applyRootPath(String rootPath) {
        this.rootPath = rootPath;
        return rootPath;
    }

    public StringBuilder applyNameBuilder(String rootPath) {
        this.nameBuilder.replace(0, this.nameBuilder.length(), rootPath);
        return this.nameBuilder;
    }

    public StringBuilder getNameBuilder() {
        return this.nameBuilder;
    }

    public void reportProblem(RuntimeException problem) {
        this.problems.add(new ConfigValidationException.Problem(problem.toString()));
    }

    List<ConfigValidationException.Problem> getProblems() {
        return this.problems;
    }

    Map<Class<?>, Map<String, ConfigMappingObject>> getRootsMap() {
        return this.roots;
    }

    private void matchPropertiesWithEnv(Map<Class<?>, Set<String>> roots) {
        HashSet<String> rootPaths = new HashSet<String>();
        for (Set<String> paths : roots.values()) {
            rootPaths.addAll(paths);
        }
        boolean all = rootPaths.contains("");
        StringBuilder sb = new StringBuilder();
        for (ConfigSource configSource : this.config.getConfigSources(EnvConfigSource.class)) {
            if (roots.isEmpty()) break;
            EnvConfigSource envConfigSource = (EnvConfigSource)configSource;
            Set<String> mutableEnvProperties = envConfigSource.getPropertyNames();
            ArrayList<String> envProperties = new ArrayList<String>(mutableEnvProperties);
            for (String envProperty : envProperties) {
                String activeEnvProperty = envProperty.charAt(0) == '%' ? ProfileConfigSourceInterceptor.activeName(envProperty, this.config.getProfiles()) : envProperty;
                String matchedRoot = null;
                if (!all) {
                    for (String string : rootPaths) {
                        if (!StringUtil.isInPath(string, activeEnvProperty)) continue;
                        matchedRoot = string;
                        break;
                    }
                    if (matchedRoot == null) {
                        continue;
                    }
                } else {
                    matchedRoot = "";
                }
                block4: for (Map map : this.names.getNames().values()) {
                    List propertyNames = (List)map.get(new PropertyName(""));
                    if (propertyNames == null) continue;
                    for (PropertyName mappedName : propertyNames) {
                        Object name = matchedRoot.isEmpty() ? mappedName.getName() : matchedRoot + "." + mappedName.getName();
                        List<Integer> indexOfDashes = ConfigMappingContext.indexOfDashes((String)name, activeEnvProperty);
                        if (indexOfDashes == null) continue;
                        sb.append(activeEnvProperty);
                        for (Integer dash : indexOfDashes) {
                            sb.setCharAt(dash, '-');
                        }
                        String expectedEnvProperty = sb.toString();
                        if (!activeEnvProperty.equals(expectedEnvProperty)) {
                            envConfigSource.getPropertyNames().add(sb.toString());
                            envConfigSource.getPropertyNames().remove(envProperty);
                        }
                        sb.setLength(0);
                        continue block4;
                    }
                }
            }
        }
    }

    private static List<Integer> indexOfDashes(String mappedProperty, String envProperty) {
        if (mappedProperty.length() > envProperty.length()) {
            return null;
        }
        ArrayList<Integer> dashesPosition = null;
        int matchPosition = envProperty.length() - 1;
        for (int i = mappedProperty.length() - 1; i >= 0; --i) {
            char p;
            if (matchPosition == -1) {
                return null;
            }
            char c = mappedProperty.charAt(i);
            if (c == '.' || c == '-') {
                p = envProperty.charAt(matchPosition);
                if (p != '.' && p != '-') {
                    return null;
                }
                if (c == '-') {
                    if (dashesPosition == null) {
                        dashesPosition = new ArrayList<Integer>();
                    }
                    dashesPosition.add(matchPosition);
                }
                --matchPosition;
                continue;
            }
            if (c == '*') {
                p = envProperty.charAt(matchPosition);
                if (p == '\"' && (matchPosition = envProperty.lastIndexOf(34, matchPosition - 1)) != -1) {
                    matchPosition = envProperty.lastIndexOf(46, matchPosition);
                }
                matchPosition = envProperty.lastIndexOf(46, matchPosition);
                continue;
            }
            if (c == ']') {
                i -= 2;
                if ((matchPosition = envProperty.lastIndexOf(91, matchPosition)) == -1) continue;
                --matchPosition;
                continue;
            }
            if (c != envProperty.charAt(matchPosition)) {
                return null;
            }
            --matchPosition;
        }
        return dashesPosition;
    }

    void reportUnknown(List<String> ignoredPaths) {
        KeyMap ignoredProperties = new KeyMap();
        for (String ignoredPath : ignoredPaths) {
            KeyMap<Boolean> found;
            if (ignoredPath.endsWith(".**")) {
                found = ignoredProperties.findOrAdd(ignoredPath.substring(0, ignoredPath.length() - 3));
                found.putRootValue(Boolean.TRUE);
                ConfigMappingContext.ignoreRecursively(found);
                continue;
            }
            if (ignoredProperties.hasRootValue(ignoredPath)) continue;
            found = ignoredProperties.findOrAdd(ignoredPath);
            found.putRootValue(Boolean.TRUE);
        }
        HashSet<String> roots = new HashSet<String>();
        for (Map<String, ConfigMappingObject> value : this.roots.values()) {
            roots.addAll(value.keySet());
        }
        for (String name : ConfigMappingContext.filterPropertiesInRoots(this.config.getPropertyNames(), roots)) {
            ConfigValue configValue;
            if (this.usedProperties.contains(name) || ignoredProperties.hasRootValue(name) || (configValue = this.config.getConfigValue(name)).getSourceName().startsWith("EnvConfigSource")) continue;
            this.problems.add(new ConfigValidationException.Problem(ConfigMessages.msg.propertyDoesNotMapToAnyRoot(name, configValue.getLocation())));
        }
    }

    private static void ignoreRecursively(KeyMap<Boolean> root) {
        if (root.getRootValue() == null) {
            root.putRootValue(Boolean.TRUE);
        }
        if (root.getAny() == null) {
            root.putAny(root);
        } else {
            KeyMap<Boolean> any = root.getAny();
            if (root != any) {
                ConfigMappingContext.ignoreRecursively(any);
            }
        }
        for (KeyMap value : root.values()) {
            ConfigMappingContext.ignoreRecursively(value);
        }
    }

    private static Iterable<String> filterPropertiesInRoots(Iterable<String> properties, Set<String> roots) {
        if (roots.isEmpty()) {
            return properties;
        }
        if (roots.contains("")) {
            return properties;
        }
        ArrayList<String> matchedProperties = new ArrayList<String>();
        block0: for (String property : properties) {
            for (String root : roots) {
                if (!ConfigMappingContext.isPropertyInRoot(property, root)) continue;
                matchedProperties.add(property);
                continue block0;
            }
        }
        return matchedProperties;
    }

    private static boolean isPropertyInRoot(String property, String root) {
        if (property.equals(root)) {
            return true;
        }
        if (property.length() <= root.length()) {
            return false;
        }
        char c = property.charAt(root.length());
        if (c == '.' || c == '[') {
            return property.startsWith(root);
        }
        return false;
    }

    static class MapWithDefault<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1390928078837140814L;
        private final V defaultValue;

        MapWithDefault(V defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object key) {
            return this.getOrDefault(key, this.defaultValue);
        }
    }

    public class ObjectCreator<T> {
        private T root;
        private List<Consumer<Function<String, Object>>> creators;

        public ObjectCreator(final String path) {
            this.creators = List.of(new Consumer<Function<String, Object>>(){

                @Override
                public void accept(Function<String, Object> get) {
                    ObjectCreator.this.root = get.apply(path);
                }
            });
        }

        public <K> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith) {
            return this.map(keyRawType, keyConvertWith, null);
        }

        public <K> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, String unnamedKey) {
            return this.map(keyRawType, keyConvertWith, unnamedKey, (Class)null);
        }

        public <K, V> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, String unnamedKey, final Class<V> defaultClass) {
            Supplier supplier = null;
            if (defaultClass != null) {
                supplier = new Supplier<V>(){

                    @Override
                    public V get() {
                        int length = ConfigMappingContext.this.nameBuilder.length();
                        ConfigMappingContext.this.nameBuilder.append(".*");
                        Object defaultValue = ConfigMappingContext.this.constructGroup(defaultClass);
                        ConfigMappingContext.this.nameBuilder.setLength(length);
                        return defaultValue;
                    }
                };
            }
            return this.map(keyRawType, keyConvertWith, unnamedKey, supplier);
        }

        public <K, V> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, final String unnamedKey, final Supplier<V> defaultValue) {
            final Converter<Object> keyConverter = keyConvertWith == null ? ConfigMappingContext.this.config.requireConverter(keyRawType) : ConfigMappingContext.this.getConverterInstance(keyConvertWith);
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        HashMap map;
                        HashMap hashMap = map = defaultValue != null ? new MapWithDefault(defaultValue.get()) : new HashMap();
                        if (unnamedKey != null) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    Object value = get.apply(path);
                                    if (value != null) {
                                        map.put(unnamedKey.equals("") ? null : (Object)keyConverter.convert(unnamedKey), value);
                                    }
                                }
                            });
                        }
                        HashMap<String, String> mapKeys = new HashMap<String, String>();
                        final HashMap<String, List<String>> mapProperties = new HashMap<String, List<String>>();
                        for (final String string : ConfigMappingContext.this.config.getPropertyNames()) {
                            if (string.length() <= path.length() + 1 || !path.isEmpty() && string.charAt(path.length()) != '.' || !string.startsWith(path)) continue;
                            final NameIterator mapProperty = !path.isEmpty() ? new NameIterator(StringUtil.unindexed(string), path.length()) : new NameIterator(StringUtil.unindexed(string));
                            mapProperty.next();
                            String mapKey = StringUtil.unindexed(mapProperty.getPreviousSegment());
                            mapKeys.computeIfAbsent(mapKey, new Function<String, String>(){

                                @Override
                                public String apply(String s) {
                                    return StringUtil.unindexed(string.substring(0, mapProperty.getPosition()));
                                }
                            });
                            mapProperties.computeIfAbsent(mapKey, new Function<String, List<String>>(){

                                @Override
                                public List<String> apply(String s) {
                                    return new ArrayList<String>();
                                }
                            });
                            ((List)mapProperties.get(mapKey)).add(string);
                        }
                        for (final Map.Entry entry : mapKeys.entrySet()) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    Object value;
                                    if (unnamedKey != null) {
                                        boolean allUsed = true;
                                        for (String mapProperty : (List)mapProperties.get(entry.getKey())) {
                                            if (ConfigMappingContext.this.usedProperties.contains(mapProperty)) continue;
                                            allUsed = false;
                                            break;
                                        }
                                        if (allUsed) {
                                            return;
                                        }
                                    }
                                    if ((value = get.apply((String)entry.getValue())) != null) {
                                        map.put(keyConverter.convert((String)entry.getKey()), value);
                                    }
                                }
                            });
                        }
                        return map;
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> collection(Class<C> collectionRawType) {
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            IntFunction<Collection<C>> collectionFactory = this.createCollectionFactory(collectionRawType);
            for (Consumer<Function<String, Object>> creator : this.creators) {
                final Collection<C> collection = collectionFactory.apply(0);
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        for (final Integer index : ConfigMappingContext.this.config.getIndexedPropertiesIndexes(path)) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    collection.add(get.apply(path + "[" + index + "]"));
                                }
                            });
                        }
                        return collection;
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> optionalCollection(Class<C> collectionRawType) {
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            IntFunction<Collection<C>> collectionFactory = this.createCollectionFactory(collectionRawType);
            for (Consumer<Function<String, Object>> creator : this.creators) {
                final Collection<C> collection = collectionFactory.apply(0);
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        List<Integer> indexes = ConfigMappingContext.this.config.getIndexedPropertiesIndexes(path);
                        for (final Integer index : indexes) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    collection.add(get.apply(path + "[" + index + "]"));
                                }
                            });
                        }
                        return indexes.isEmpty() ? Optional.empty() : Optional.of(collection);
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <G> ObjectCreator<T> group(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public G apply(String path) {
                        StringBuilder sb = ConfigMappingContext.this.getNameBuilder();
                        int length = sb.length();
                        sb.append(path, length, path.length());
                        Object group = ConfigMappingContext.this.constructGroup(groupType);
                        sb.setLength(length);
                        return group;
                    }
                });
            }
            return this;
        }

        public <G> ObjectCreator<T> lazyGroup(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public G apply(String path) {
                        if (ObjectCreator.this.createRequired(groupType, path)) {
                            StringBuilder sb = ConfigMappingContext.this.getNameBuilder();
                            int length = sb.length();
                            sb.append(path, length, path.length());
                            Object group = ConfigMappingContext.this.constructGroup(groupType);
                            sb.setLength(length);
                            return group;
                        }
                        return null;
                    }
                });
            }
            return this;
        }

        public <G> ObjectCreator<T> optionalGroup(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Optional<G> apply(String path) {
                        if (ObjectCreator.this.createRequired(groupType, path)) {
                            StringBuilder sb = ConfigMappingContext.this.getNameBuilder();
                            int length = sb.length();
                            sb.append(path, length, path.length());
                            Object group = ConfigMappingContext.this.constructGroup(groupType);
                            sb.setLength(length);
                            return Optional.of(group);
                        }
                        return Optional.empty();
                    }
                });
            }
            return this;
        }

        public ObjectCreator<T> value(final Class<T> valueRawType, final Class<? extends Converter<T>> valueConvertWith) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public T apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        return ConfigMappingContext.this.config.getValue(propertyName, valueConverter);
                    }
                });
            }
            return this;
        }

        public <V> ObjectCreator<T> optionalValue(final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Optional<V> apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        return ConfigMappingContext.this.config.getOptionalValue(propertyName, valueConverter);
                    }
                });
            }
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> values(final Class<V> itemRawType, final Class<? extends Converter<V>> itemConvertWith, final Class<C> collectionRawType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public T apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getIndexedProperties(propertyName));
                        Converter itemConverter = itemConvertWith == null ? ConfigMappingContext.this.config.requireConverter(itemRawType) : ConfigMappingContext.this.getConverterInstance(itemConvertWith);
                        IntFunction<Collection<?>> collectionFactory = ObjectCreator.this.createCollectionFactory(collectionRawType);
                        return ConfigMappingContext.this.config.getValues(propertyName, itemConverter, collectionFactory);
                    }
                });
            }
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> optionalValues(final Class<V> itemRawType, final Class<? extends Converter<V>> itemConvertWith, final Class<C> collectionRawType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public T apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getIndexedProperties(propertyName));
                        Converter itemConverter = ObjectCreator.this.getConverter(itemRawType, itemConvertWith);
                        IntFunction<Collection<?>> collectionFactory = ObjectCreator.this.createCollectionFactory(collectionRawType);
                        return ConfigMappingContext.this.config.getOptionalValues(propertyName, itemConverter, collectionFactory);
                    }
                });
            }
            return this;
        }

        public <K, V> ObjectCreator<T> values(final Class<K> keyRawType, final Class<? extends Converter<K>> keyConvertWith, final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith, final String defaultValue) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                Function<String, Object> values = new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getMapKeys(propertyName).values());
                        Converter keyConverter = ObjectCreator.this.getConverter(keyRawType, keyConvertWith);
                        final Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        if (defaultValue == null) {
                            try {
                                return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, HashMap::new).orElse(Collections.EMPTY_MAP);
                            }
                            catch (NoSuchElementException e) {
                                return Collections.EMPTY_MAP;
                            }
                        }
                        IntFunction mapFactory = new IntFunction<Map<K, V>>(){

                            @Override
                            public Map<K, V> apply(int value) {
                                return new MapWithDefault(valueConverter.convert(defaultValue));
                            }
                        };
                        try {
                            return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, mapFactory).orElse((Map)mapFactory.apply(0));
                        }
                        catch (NoSuchElementException e) {
                            return mapFactory.apply(0);
                        }
                    }
                };
                creator.accept(values);
            }
            return this;
        }

        public <K, V, C extends Collection<V>> ObjectCreator<T> values(final Class<K> keyRawType, final Class<? extends Converter<K>> keyConvertWith, final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith, final Class<C> collectionRawType, final String defaultValue) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                Function<String, Object> values = new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getMapKeys(propertyName).values());
                        Converter keyConverter = ObjectCreator.this.getConverter(keyRawType, keyConvertWith);
                        final Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        final IntFunction<Collection<?>> collectionFactory = ObjectCreator.this.createCollectionFactory(collectionRawType);
                        if (defaultValue == null) {
                            return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, HashMap::new, collectionFactory).orElse(new HashMap());
                        }
                        IntFunction mapFactory = new IntFunction<Map<K, C>>(){

                            @Override
                            public Map<K, C> apply(int value) {
                                return new MapWithDefault((Collection)Converters.newCollectionConverter(valueConverter, collectionFactory).convert(defaultValue));
                            }
                        };
                        return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, mapFactory, collectionFactory).orElse((Map)mapFactory.apply(0));
                    }
                };
                creator.accept(values);
            }
            return this;
        }

        public T get() {
            return this.root;
        }

        private <V> Converter<V> getConverter(Class<V> rawType, Class<? extends Converter<V>> convertWith) {
            return convertWith == null ? ConfigMappingContext.this.config.requireConverter(rawType) : ConfigMappingContext.this.getConverterInstance(convertWith);
        }

        private <G> boolean createRequired(Class<G> groupType, String path) {
            return ConfigMappingContext.this.names.hasAnyName(groupType.getName(), ConfigMappingContext.this.rootPath, path, ConfigMappingContext.this.config.getPropertyNames());
        }

        private IntFunction<Collection<?>> createCollectionFactory(Class<?> type) {
            if (type == List.class) {
                return ArrayList::new;
            }
            if (type == Set.class) {
                return HashSet::new;
            }
            throw new IllegalArgumentException();
        }
    }
}

