/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.cryostat.libcryostat.net;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.cryostat.agent.shaded.org.apache.shaded.commons.lang3.builder.ToStringBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class RuntimeMetrics {
    private String bootClassPath;
    private String classPath;
    private String[] inputArguments;
    private String libraryPath;
    private String managementSpecVersion;
    private String name;
    private String specName;
    private String specVendor;
    private String specVersion;
    private Map<String, String> systemProperties;
    private long startTime;
    private long uptime;
    private String vmName;
    private String vmVendor;
    private String vmVersion;
    private boolean bootClassPathSupported;

    public RuntimeMetrics() {
    }

    public RuntimeMetrics(Map<String, Object> attributes) {
        this.bootClassPath = (String)attributes.getOrDefault("BootClassPath", "");
        this.classPath = (String)attributes.getOrDefault("ClassPath", "");
        this.inputArguments = (String[])attributes.getOrDefault("InputArguments", new String[0]);
        this.libraryPath = (String)attributes.getOrDefault("LibraryPath", "");
        this.managementSpecVersion = (String)attributes.getOrDefault("ManagementSpecVersion", "");
        this.name = (String)attributes.getOrDefault("Name", "");
        this.specName = (String)attributes.getOrDefault("SpecName", "");
        this.specVendor = (String)attributes.getOrDefault("SpecVendor", "");
        this.specVersion = (String)attributes.getOrDefault("SpecVersion", "");
        this.systemProperties = attributes.getOrDefault("SystemProperties", Map.of());
        this.startTime = (Long)attributes.getOrDefault("StartTime", Long.MIN_VALUE);
        this.uptime = (Long)attributes.getOrDefault("Uptime", Long.MIN_VALUE);
        this.vmName = (String)attributes.getOrDefault("VmName", "");
        this.vmVendor = (String)attributes.getOrDefault("VmVendor", "");
        this.vmVersion = (String)attributes.getOrDefault("VmVersion", "");
        this.bootClassPathSupported = (Boolean)attributes.getOrDefault("BootClassPathSupported", false);
    }

    public static RuntimeMetrics readLocalMetrics() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        RuntimeMetrics.store(attrs, "BootClassPath", bean::getBootClassPath);
        RuntimeMetrics.store(attrs, "ClassPath", bean::getClassPath);
        RuntimeMetrics.store(attrs, "InputArguments", () -> bean.getInputArguments().toArray(new String[0]));
        RuntimeMetrics.store(attrs, "LibraryPath", bean::getLibraryPath);
        RuntimeMetrics.store(attrs, "ManagementSpecVersion", bean::getManagementSpecVersion);
        RuntimeMetrics.store(attrs, "Name", bean::getName);
        RuntimeMetrics.store(attrs, "SpecName", bean::getSpecName);
        RuntimeMetrics.store(attrs, "SpecVendor", bean::getSpecVendor);
        RuntimeMetrics.store(attrs, "SpecVersion", bean::getSpecVersion);
        RuntimeMetrics.store(attrs, "SystemProperties", bean::getSystemProperties);
        RuntimeMetrics.store(attrs, "StartTime", bean::getStartTime);
        RuntimeMetrics.store(attrs, "Uptime", bean::getUptime);
        RuntimeMetrics.store(attrs, "VmName", bean::getVmName);
        RuntimeMetrics.store(attrs, "VmVendor", bean::getVmVendor);
        RuntimeMetrics.store(attrs, "VmVersion", bean::getVmVersion);
        RuntimeMetrics.store(attrs, "BootClassPathSupported", bean::isBootClassPathSupported);
        return new RuntimeMetrics(attrs);
    }

    private static void store(Map<String, Object> map, String key, Supplier<?> supplier) {
        try {
            Object s = supplier.get();
            if (s != null) {
                map.put(key, s);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public String getManagementSpecVersion() {
        return this.managementSpecVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecName() {
        return this.specName;
    }

    public String getSpecVendor() {
        return this.specVendor;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public long getUptime() {
        return this.uptime;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public boolean isBootClassPathSupported() {
        return this.bootClassPathSupported;
    }

    public String toString() {
        return new ToStringBuilder(this).append("bootClassPath", this.bootClassPath).append("classPath", this.classPath).append("inputArguments", this.inputArguments).append("libraryPath", this.libraryPath).append("managementSpecVersion", this.managementSpecVersion).append("name", this.name).append("specName", this.specName).append("specVendor", this.specVendor).append("specVersion", this.specVersion).append("systemProperties", this.systemProperties).append("startTime", this.startTime).append("uptime", this.uptime).append("vmName", this.vmName).append("vmVendor", this.vmVendor).append("vmVersion", this.vmVersion).append("bootClassPathSupported", this.bootClassPathSupported).build();
    }
}

