/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.cryostat.libcryostat.net;

import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.MemoryUtilization;
import io.cryostat.agent.shaded.org.apache.shaded.commons.lang3.builder.ToStringBuilder;
import java.lang.management.MemoryUsage;
import java.util.Map;

public class MemoryMetrics {
    private MemoryUtilization heapMemoryUsage;
    private MemoryUtilization nonHeapMemoryUsage;
    private long objectPendingFinalizationCount;
    private long freeHeapMemory;
    private long freeNonHeapMemory;
    private double heapMemoryUsagePercent;
    private boolean verbose;

    public MemoryMetrics() {
    }

    public MemoryMetrics(Map<String, Object> attributes) {
        this.heapMemoryUsage = MemoryUtilization.from((MemoryUsage)attributes.getOrDefault("HeapMemoryUsage", new MemoryUsage(-1L, 0L, 0L, -1L)));
        this.nonHeapMemoryUsage = MemoryUtilization.from((MemoryUsage)attributes.getOrDefault("NonHeapMemoryUsage", new MemoryUsage(-1L, 0L, 0L, -1L)));
        this.objectPendingFinalizationCount = ((Integer)attributes.getOrDefault("ObjectPendingFinalizationCount", Integer.MIN_VALUE)).intValue();
        this.freeHeapMemory = (Long)attributes.getOrDefault("FreeHeapMemory", Long.MIN_VALUE);
        this.freeNonHeapMemory = (Long)attributes.getOrDefault("FreeNonHeapMemory", Long.MIN_VALUE);
        this.heapMemoryUsagePercent = (Double)attributes.getOrDefault("HeapMemoryUsagePercent", Double.MIN_VALUE);
        this.verbose = (Boolean)attributes.getOrDefault("Verbose", false);
    }

    public MemoryUtilization getHeapMemoryUsage() {
        return this.heapMemoryUsage;
    }

    public MemoryUtilization getNonHeapMemoryUsage() {
        return this.nonHeapMemoryUsage;
    }

    public long getObjectPendingFinalizationCount() {
        return this.objectPendingFinalizationCount;
    }

    public long getFreeHeapMemory() {
        return this.freeHeapMemory;
    }

    public long getFreeNonHeapMemory() {
        return this.freeNonHeapMemory;
    }

    public double getHeapMemoryUsagePercent() {
        return this.heapMemoryUsagePercent;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String toString() {
        return new ToStringBuilder(this).append("heapMemoryUsage", this.heapMemoryUsage).append("nonHeapMemoryUsage", this.nonHeapMemoryUsage).append("objectPendingFinalizationCount", this.objectPendingFinalizationCount).append("freeHeapMemory", this.freeHeapMemory).append("freeNonHeapMemory", this.freeNonHeapMemory).append("heapMemoryUsagePercent", this.heapMemoryUsagePercent).append("verbose", this.verbose).build();
    }
}

