/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.io.cryostat.libcryostat;

import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.IDException;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.RuntimeMetrics;
import io.cryostat.agent.shaded.org.apache.shaded.commons.codec.digest.DigestUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class JvmIdentifier {
    private final String hash;

    private JvmIdentifier(String hash) {
        this.hash = hash;
    }

    public static JvmIdentifier getLocal() throws IDException {
        return JvmIdentifier.from(RuntimeMetrics.readLocalMetrics());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JvmIdentifier from(RuntimeMetrics metrics) throws IDException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(512);){
            JvmIdentifier jvmIdentifier;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                JvmIdentifier.safeWrite(dos, metrics.getClassPath());
                JvmIdentifier.safeWrite(dos, metrics.getName());
                JvmIdentifier.safeWrite(dos, JvmIdentifier.stringifyArray(metrics.getInputArguments()));
                JvmIdentifier.safeWrite(dos, metrics.getLibraryPath());
                JvmIdentifier.safeWrite(dos, metrics.getVmVendor());
                JvmIdentifier.safeWrite(dos, metrics.getVmVersion());
                dos.writeLong(metrics.getStartTime());
                byte[] hash = DigestUtils.sha256(baos.toByteArray());
                jvmIdentifier = new JvmIdentifier(new String(Base64.getUrlEncoder().encode(hash), StandardCharsets.UTF_8).trim());
            }
            return jvmIdentifier;
        }
        catch (IOException e) {
            throw new IDException(e);
        }
    }

    private static void safeWrite(DataOutputStream dos, String value) throws IOException {
        if (value == null) {
            return;
        }
        dos.writeUTF(value);
    }

    public String getHash() {
        return this.hash;
    }

    private static String stringifyArray(Object arrayObject) {
        String stringified;
        String componentType;
        if (arrayObject == null) {
            return null;
        }
        switch (componentType = arrayObject.getClass().getComponentType().toString()) {
            case "boolean": {
                stringified = Arrays.toString((boolean[])arrayObject);
                break;
            }
            case "byte": {
                stringified = Arrays.toString((byte[])arrayObject);
                break;
            }
            case "char": {
                stringified = Arrays.toString((char[])arrayObject);
                break;
            }
            case "short": {
                stringified = Arrays.toString((short[])arrayObject);
                break;
            }
            case "int": {
                stringified = Arrays.toString((int[])arrayObject);
                break;
            }
            case "long": {
                stringified = Arrays.toString((long[])arrayObject);
                break;
            }
            case "float": {
                stringified = Arrays.toString((float[])arrayObject);
                break;
            }
            case "double": {
                stringified = Arrays.toString((double[])arrayObject);
                break;
            }
            default: {
                stringified = Arrays.toString((Object[])arrayObject);
            }
        }
        return stringified;
    }

    public String toString() {
        return this.hash;
    }

    public int hashCode() {
        return Objects.hash(this.hash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JvmIdentifier other = (JvmIdentifier)obj;
        return Objects.equals(this.hash, other.hash);
    }
}

