/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.remote;

import com.sun.net.httpserver.HttpExchange;
import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.remote.MutatingRemoteContext;
import io.cryostat.agent.remote.RemoteContext;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.serialization.SerializableRecordingDescriptor;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.templates.InvalidEventTemplateException;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.Config;
import io.cryostat.agent.shaded.org.slf4j.Logger;
import io.cryostat.agent.shaded.org.slf4j.LoggerFactory;
import io.cryostat.agent.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;

class RecordingsContext
implements RemoteContext {
    private static final String PATH = "/recordings/";
    private static final Pattern PATH_ID_PATTERN = Pattern.compile("^/recordings/(\\d+)$", 8);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Config config;
    private final ObjectMapper mapper;
    private final FlightRecorderHelper flightRecorder;

    @Inject
    RecordingsContext(Config config, ObjectMapper mapper, FlightRecorderHelper flightRecorder) {
        this.config = config;
        this.mapper = mapper;
        this.flightRecorder = flightRecorder;
    }

    @Override
    public String path() {
        return PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String mtd = exchange.getRequestMethod();
            if (!this.ensureMethodAccepted(exchange)) {
                return;
            }
            long id = Long.MIN_VALUE;
            switch (mtd) {
                case "GET": {
                    id = RecordingsContext.extractId(exchange);
                    if (id == Long.MIN_VALUE) {
                        this.handleGetList(exchange);
                        return;
                    } else {
                        this.handleGetRecording(exchange, id);
                        return;
                    }
                }
                case "POST": {
                    this.handleStartRecordingOrSnapshot(exchange);
                    return;
                }
                case "PATCH": {
                    id = RecordingsContext.extractId(exchange);
                    if (id >= 0L) {
                        this.handleStopOrUpdate(exchange, id);
                        return;
                    } else {
                        exchange.sendResponseHeaders(400, -1L);
                        return;
                    }
                }
                case "DELETE": {
                    id = RecordingsContext.extractId(exchange);
                    if (id >= 0L) {
                        this.handleDelete(exchange, id);
                        return;
                    } else {
                        exchange.sendResponseHeaders(400, -1L);
                        return;
                    }
                }
                default: {
                    this.log.warn("Unknown request method {}", (Object)mtd);
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
            }
        }
        finally {
            exchange.close();
        }
    }

    private static long extractId(HttpExchange exchange) throws IOException {
        Matcher m = PATH_ID_PATTERN.matcher(exchange.getRequestURI().getPath());
        if (!m.find()) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(m.group(1));
    }

    private void handleGetList(HttpExchange exchange) {
        try (OutputStream response = exchange.getResponseBody();){
            List recordings = this.flightRecorder.getRecordings().stream().map(SerializableRecordingDescriptor::new).collect(Collectors.toList());
            exchange.sendResponseHeaders(200, 0L);
            this.mapper.writeValue(response, recordings);
        }
        catch (Exception e) {
            this.log.error("recordings serialization failure", e);
        }
    }

    private void handleGetRecording(HttpExchange exchange, long recordingId) {
        this.flightRecorder.getRecording(recordingId).ifPresentOrElse(r -> {
            try (Recording copy = r.copy(true);
                 InputStream stream = copy.getStream(null, null);
                 BufferedInputStream bis = new BufferedInputStream(stream);
                 OutputStream response = exchange.getResponseBody();){
                if (stream == null) {
                    exchange.sendResponseHeaders(204, -1L);
                } else {
                    exchange.sendResponseHeaders(200, 0L);
                    bis.transferTo(response);
                }
            }
        }, () -> {
            try {
                exchange.sendResponseHeaders(404, -1L);
            }
            catch (IOException e) {
                this.log.error("Failed to write response", e);
            }
        });
    }

    private void handleStartRecordingOrSnapshot(HttpExchange exchange) throws IOException {
        try (InputStream body = exchange.getRequestBody();){
            StartRecordingRequest req = this.mapper.readValue(body, StartRecordingRequest.class);
            if (req.requestSnapshot()) {
                SerializableRecordingDescriptor snapshot;
                block29: {
                    snapshot = this.flightRecorder.createSnapshot().map(SerializableRecordingDescriptor::new).orElse(null);
                    if (snapshot != null) break block29;
                    exchange.sendResponseHeaders(503, -1L);
                    return;
                }
                try {
                    exchange.sendResponseHeaders(201, 0L);
                    try (OutputStream response = exchange.getResponseBody();){
                        this.mapper.writeValue(response, (Object)snapshot);
                    }
                }
                catch (IOException e) {
                    this.log.error("Failed to start snapshot", e);
                    exchange.sendResponseHeaders(503, -1L);
                }
                return;
            }
            if (!req.isValid()) {
                this.log.warn("Invalid recording start request: {}", (Object)req);
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            SerializableRecordingDescriptor recording = this.startRecording(req);
            exchange.sendResponseHeaders(201, 0L);
            try (OutputStream response = exchange.getResponseBody();){
                this.mapper.writeValue(response, (Object)recording);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to start recording", e);
            exchange.sendResponseHeaders(500, -1L);
        }
        catch (InvalidEventTemplateException e) {
            this.log.warn("Invalid custom event template", e);
            exchange.sendResponseHeaders(400, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStopOrUpdate(HttpExchange exchange, long recordingId) throws IOException {
        try {
            boolean shouldStop = false;
            InputStream body = exchange.getRequestBody();
            JsonNode jsonMap = this.mapper.readTree(body);
            Iterator<Map.Entry<String, JsonNode>> fields = jsonMap.fields();
            Optional<Recording> recordingOpt = this.flightRecorder.getRecording(recordingId);
            if (recordingOpt.isEmpty()) {
                this.sendHeader(exchange, 404);
                return;
            }
            Recording recording = recordingOpt.get();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                switch (field.getKey()) {
                    case "state": {
                        if ("stopped".equalsIgnoreCase(field.getValue().textValue())) {
                            shouldStop = true;
                            break;
                        }
                        this.sendHeader(exchange, 400);
                        return;
                    }
                    case "name": {
                        if (!StringUtils.isBlank(field.getValue().textValue())) {
                            recording.setName(field.getValue().textValue());
                            break;
                        }
                        this.sendHeader(exchange, 400);
                        return;
                    }
                    case "duration": {
                        if (field.getValue().canConvertToLong()) {
                            recording.setDuration(Duration.ofMillis(field.getValue().longValue()));
                            break;
                        }
                        this.sendHeader(exchange, 400);
                        return;
                    }
                    case "maxSize": {
                        if (field.getValue().canConvertToLong()) {
                            recording.setMaxSize(field.getValue().longValue());
                            break;
                        }
                        this.sendHeader(exchange, 400);
                        return;
                    }
                    case "maxAge": {
                        if (field.getValue().canConvertToLong()) {
                            recording.setMaxAge(Duration.ofMillis(field.getValue().longValue()));
                            break;
                        }
                        this.sendHeader(exchange, 400);
                        return;
                    }
                    case "toDisk": {
                        if (field.getValue().isBoolean()) {
                            recording.setToDisk(field.getValue().booleanValue());
                            break;
                        }
                        this.sendHeader(exchange, 400);
                        return;
                    }
                    default: {
                        this.log.warn("Unknown recording option {}", (Object)field.getKey());
                        this.sendHeader(exchange, 400);
                        return;
                    }
                }
            }
            if (shouldStop) {
                try {
                    if (!recording.stop()) {
                        this.sendHeader(exchange, 500);
                    }
                }
                catch (IllegalStateException e) {
                    this.sendHeader(exchange, recording.getState().equals((Object)RecordingState.STOPPED) ? 204 : 500);
                }
            }
            try (OutputStream response = exchange.getResponseBody();){
                if (response == null) {
                    this.sendHeader(exchange, 204);
                } else {
                    exchange.sendResponseHeaders(200, 0L);
                    this.mapper.writeValue(response, (Object)this.flightRecorder.getRecording(recordingId).map(SerializableRecordingDescriptor::new).get());
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to update recording", e);
            this.sendHeader(exchange, 500);
        }
        finally {
            exchange.close();
        }
    }

    private void handleDelete(HttpExchange exchange, long recordingId) throws IOException {
        try {
            Optional<Recording> opt = this.flightRecorder.getRecording(recordingId);
            if (opt.isEmpty()) {
                this.sendHeader(exchange, 404);
                return;
            }
            opt.get().close();
            this.sendHeader(exchange, 204);
        }
        catch (Exception e) {
            this.log.error("Operation failed", e);
            this.sendHeader(exchange, 500);
        }
    }

    private void sendHeader(HttpExchange exchange, int status) {
        try {
            exchange.sendResponseHeaders(status, -1L);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean ensureMethodAccepted(HttpExchange exchange) throws IOException {
        String mtd;
        boolean restricted;
        Set<String> alwaysAllowed = Set.of("GET");
        boolean bl = restricted = !alwaysAllowed.contains(mtd = exchange.getRequestMethod());
        if (!restricted) {
            return true;
        }
        boolean passed = MutatingRemoteContext.apiWritesEnabled(this.config);
        if (!passed) {
            exchange.sendResponseHeaders(403, -1L);
        }
        return passed;
    }

    private SerializableRecordingDescriptor startRecording(StartRecordingRequest req) throws InvalidEventTemplateException {
        Recording recording;
        if (req.requestsCustomTemplate()) {
            try {
                recording = this.flightRecorder.createRecordingWithCustomTemplate(req.template);
            }
            catch (IOException | ParseException e) {
                throw new InvalidEventTemplateException("Invalid event template contents", e);
            }
        } else {
            recording = this.flightRecorder.createRecordingWithPredefinedTemplate(req.localTemplateName).orElseThrow(() -> new InvalidEventTemplateException(req.localTemplateName)).getRecording();
        }
        recording.setName(req.name);
        recording.setToDisk(true);
        recording.setDuration(req.duration > 0L ? Duration.ofMillis(req.duration) : null);
        recording.setMaxSize(req.maxSize);
        recording.setMaxAge(Duration.ofMillis(req.maxAge));
        recording.start();
        return new SerializableRecordingDescriptor(recording);
    }

    static class StartRecordingRequest {
        public String name;
        public String localTemplateName;
        public String template;
        public long duration;
        public long maxSize;
        public long maxAge;

        StartRecordingRequest() {
        }

        boolean requestsCustomTemplate() {
            return !StringUtils.isBlank(this.template);
        }

        boolean requestsBundledTemplate() {
            return !StringUtils.isBlank(this.localTemplateName);
        }

        boolean requestSnapshot() {
            boolean snapshotName = this.name.equals("snapshot");
            boolean snapshotTemplate = StringUtils.isBlank(this.template) && StringUtils.isBlank(this.localTemplateName);
            boolean snapshotFeatures = this.duration == 0L && this.maxSize == 0L && this.maxAge == 0L;
            return snapshotName && snapshotTemplate && snapshotFeatures;
        }

        boolean isValid() {
            boolean requestsCustomTemplate = this.requestsCustomTemplate();
            boolean requestsBundledTemplate = this.requestsBundledTemplate();
            boolean requestsEither = requestsCustomTemplate || requestsBundledTemplate;
            boolean requestsBoth = requestsCustomTemplate && requestsBundledTemplate;
            return requestsEither && !requestsBoth || this.requestSnapshot();
        }
    }
}

