/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.remote;

import com.sun.net.httpserver.HttpExchange;
import io.cryostat.agent.remote.MutatingRemoteContext;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.Config;
import io.cryostat.agent.shaded.org.slf4j.Logger;
import io.cryostat.agent.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class InvokeContext
extends MutatingRemoteContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper;

    @Inject
    InvokeContext(ObjectMapper mapper, Config config) {
        super(config);
        this.mapper = mapper;
    }

    @Override
    public String path() {
        return "/mbean-invoke/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String mtd;
            switch (mtd = exchange.getRequestMethod()) {
                case "POST": {
                    try (InputStream body = exchange.getRequestBody();){
                        MBeanServer server;
                        Object response;
                        MBeanInvocationRequest req = this.mapper.readValue(body, MBeanInvocationRequest.class);
                        if (!req.isValid()) {
                            exchange.sendResponseHeaders(400, -1L);
                        }
                        if (Objects.nonNull(response = (server = ManagementFactory.getPlatformMBeanServer()).invoke(ObjectName.getInstance(req.beanName), req.operation, req.parameters, req.signature))) {
                            exchange.sendResponseHeaders(200, 0L);
                            try (OutputStream responseStream = exchange.getResponseBody();){
                                this.mapper.writeValue(responseStream, response);
                                return;
                            }
                        }
                        exchange.sendResponseHeaders(202, -1L);
                        return;
                    }
                    catch (Exception e) {
                        this.log.error("mbean serialization failure", e);
                        exchange.sendResponseHeaders(502, -1L);
                        return;
                    }
                }
                default: {
                    this.log.warn("Unknown request method {}", (Object)mtd);
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
            }
        }
        finally {
            exchange.close();
        }
    }

    static class MBeanInvocationRequest<T> {
        public String beanName;
        public String operation;
        public Object[] parameters;
        public String[] signature;

        MBeanInvocationRequest() {
        }

        public boolean isValid() {
            return this.beanName.equals("java.lang:type=Memory");
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }
    }
}

