/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.model;

import com.sun.management.UnixOperatingSystemMXBean;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.MBeanMetrics;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.MemoryMetrics;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.OperatingSystemMetrics;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.RuntimeMetrics;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.ThreadMetrics;
import io.cryostat.agent.shaded.org.apache.shaded.commons.codec.digest.DigestUtils;
import io.cryostat.agent.shaded.org.slf4j.Logger;
import io.cryostat.agent.shaded.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class MBeanInfo {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MBeanMetrics mBeanMetrics;
    private final Map<String, Object> simplifiedMetrics = new HashMap<String, Object>();

    public MBeanInfo() {
        this.mBeanMetrics = new MBeanMetrics(this.getRuntimeMetrics(), this.getMemoryMetrics(), this.getThreadMetrics(), this.getOperatingSystemMetrics(), this.getJvmID(this.getRuntimeMetrics()));
    }

    protected final void finalize() {
    }

    public MBeanMetrics getMBeanMetrics() {
        return this.mBeanMetrics;
    }

    public Map<String, Object> getSimplifiedMetrics() {
        return Collections.unmodifiableMap(this.simplifiedMetrics);
    }

    private OperatingSystemMetrics getOperatingSystemMetrics() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        HashMap<String, Object> osAttrs = new HashMap<String, Object>();
        this.safeStore("Arch", osAttrs, osBean::getArch);
        this.safeStore("AvailableProcessors", osAttrs, osBean::getAvailableProcessors);
        this.safeStore("Name", osAttrs, osBean::getName);
        this.safeStore("SystemLoadAverage", osAttrs, osBean::getSystemLoadAverage);
        this.safeStore("Version", osAttrs, osBean::getVersion);
        if (osBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)osBean;
            this.safeStore("CommittedVirtualMemorySize", osAttrs, unix::getCommittedVirtualMemorySize);
            this.safeStore("FreePhysicalMemorySize", osAttrs, unix::getFreePhysicalMemorySize);
            this.safeStore("FreeSwapSpaceSize", osAttrs, unix::getFreeSwapSpaceSize);
            this.safeStore("ProcessCpuLoad", osAttrs, unix::getProcessCpuLoad);
            this.safeStore("ProcessCpuTime", osAttrs, unix::getProcessCpuTime);
            this.safeStore("SystemCpuLoad", osAttrs, unix::getSystemCpuLoad);
            this.safeStore("TotalPhysicalMemorySize", osAttrs, unix::getTotalPhysicalMemorySize);
            this.safeStore("TotalSwapSpaceSize", osAttrs, unix::getTotalSwapSpaceSize);
        }
        return new OperatingSystemMetrics(osAttrs);
    }

    private ThreadMetrics getThreadMetrics() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        HashMap<String, Object> threadAttrs = new HashMap<String, Object>();
        this.safeStore("AllThreadIds", threadAttrs, threadBean::getAllThreadIds);
        this.safeStore("CurrentThreadCpuTime", threadAttrs, threadBean::getCurrentThreadCpuTime);
        this.safeStore("CurrentThreadUserTime", threadAttrs, threadBean::getCurrentThreadUserTime);
        this.safeStore("DaemonThreadCount", threadAttrs, threadBean::getDaemonThreadCount);
        this.safeStore("PeakThreadCount", threadAttrs, threadBean::getPeakThreadCount);
        this.safeStore("ThreadCount", threadAttrs, threadBean::getThreadCount);
        this.safeStore("TotalStartedThreadCount", threadAttrs, threadBean::getTotalStartedThreadCount);
        this.safeStore("CurrentThreadCpuTimeSupported", threadAttrs, threadBean::isCurrentThreadCpuTimeSupported);
        this.safeStore("ObjectMonitorUsageSupported", threadAttrs, threadBean::isObjectMonitorUsageSupported);
        this.safeStore("SynchronizerUsageSupported", threadAttrs, threadBean::isSynchronizerUsageSupported);
        this.safeStore("ThreadContentionMonitoringEnabled", threadAttrs, threadBean::isThreadContentionMonitoringEnabled);
        this.safeStore("ThreadContentionMonitoringSupported", threadAttrs, threadBean::isThreadContentionMonitoringSupported);
        this.safeStore("ThreadCpuTimeEnabled", threadAttrs, threadBean::isThreadCpuTimeEnabled);
        this.safeStore("ThreadCpuTimeSupported", threadAttrs, threadBean::isThreadCpuTimeSupported);
        return new ThreadMetrics(threadAttrs);
    }

    private RuntimeMetrics getRuntimeMetrics() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        HashMap<String, Object> runtimeAttrs = new HashMap<String, Object>();
        this.safeStore("BootClassPathSupported", runtimeAttrs, runtimeBean::isBootClassPathSupported, true);
        this.safeStore("BootClassPath", runtimeAttrs, runtimeBean::getBootClassPath, true);
        this.safeStore("ClassPath", runtimeAttrs, runtimeBean::getClassPath);
        this.safeStore("InputArguments", runtimeAttrs, () -> runtimeBean.getInputArguments().toArray(new String[0]));
        this.safeStore("LibraryPath", runtimeAttrs, runtimeBean::getLibraryPath);
        this.safeStore("ManagementSpecVersion", runtimeAttrs, runtimeBean::getManagementSpecVersion);
        this.safeStore("Name", runtimeAttrs, runtimeBean::getName);
        this.safeStore("SpecName", runtimeAttrs, runtimeBean::getSpecName);
        this.safeStore("SpecVersion", runtimeAttrs, runtimeBean::getSpecVersion);
        this.safeStore("SystemProperties", runtimeAttrs, runtimeBean::getSystemProperties);
        this.safeStore("StartTime", runtimeAttrs, runtimeBean::getStartTime);
        this.safeStore("Uptime", runtimeAttrs, runtimeBean::getUptime);
        this.safeStore("VmName", runtimeAttrs, runtimeBean::getVmName);
        this.safeStore("VmVendor", runtimeAttrs, runtimeBean::getVmVendor);
        this.safeStore("VmVersion", runtimeAttrs, runtimeBean::getVmVersion);
        return new RuntimeMetrics(runtimeAttrs);
    }

    private MemoryMetrics getMemoryMetrics() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        HashMap<String, Object> memoryAttrs = new HashMap<String, Object>();
        this.safeStore("HeapMemoryUsage", memoryAttrs, memoryBean::getHeapMemoryUsage);
        this.safeStore("NonHeapMemoryUsage", memoryAttrs, memoryBean::getNonHeapMemoryUsage);
        this.safeStore("ObjectPendingFinalizationCount", memoryAttrs, memoryBean::getObjectPendingFinalizationCount);
        this.safeStore("FreeHeapMemory", memoryAttrs, () -> memoryBean.getHeapMemoryUsage().getCommitted() - memoryBean.getHeapMemoryUsage().getUsed());
        this.safeStore("FreeNonHeapMemory", memoryAttrs, () -> memoryBean.getNonHeapMemoryUsage().getCommitted() - memoryBean.getNonHeapMemoryUsage().getUsed());
        this.safeStore("HeapMemoryUsagePercent", memoryAttrs, () -> (double)memoryBean.getHeapMemoryUsage().getUsed() / (double)memoryBean.getHeapMemoryUsage().getCommitted());
        this.safeStore("Verbose", memoryAttrs, memoryBean::isVerbose);
        return new MemoryMetrics(memoryAttrs);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getJvmID(RuntimeMetrics runtime) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(512);){
            String string;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                dos.writeUTF(runtime.getClassPath());
                dos.writeUTF(runtime.getName());
                dos.writeUTF(Arrays.toString(runtime.getInputArguments()));
                dos.writeUTF(runtime.getLibraryPath());
                dos.writeUTF(runtime.getVmVendor());
                dos.writeUTF(runtime.getVmVersion());
                dos.writeLong(runtime.getStartTime());
                byte[] hash = DigestUtils.sha256(baos.toByteArray());
                string = new String(Base64.getUrlEncoder().encode(hash), StandardCharsets.UTF_8).trim();
            }
            return string;
        }
        catch (IOException e) {
            this.log.error("Could not compute own jvmId!", e);
            return "";
        }
    }

    private <T> void safeStore(String key, Map<String, Object> map, Callable<T> fn) {
        this.safeStore(key, map, fn, true);
    }

    private <T> void safeStore(String key, Map<String, Object> map, Callable<T> fn, boolean quiet) {
        block2: {
            try {
                map.put(key, fn.call());
                this.simplifiedMetrics.put(key, fn.call());
            }
            catch (Exception e) {
                if (quiet) break block2;
                this.log.warn("Call failed", e);
            }
        }
    }
}

