/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.model;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryNode {
    private String name;
    private String nodeType;
    private Target target;

    DiscoveryNode() {
    }

    public DiscoveryNode(String name, String nodeType, Target target) {
        this.name = name;
        this.nodeType = nodeType;
        this.target = new Target(target);
    }

    public String getName() {
        return this.name;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public Target getTarget() {
        return new Target(this.target);
    }

    void setName(String name) {
        this.name = name;
    }

    void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    void setTarget(Target target) {
        this.target = target;
    }

    public static class Annotations {
        private Map<String, Object> cryostat;
        private Map<String, Object> platform;

        Annotations() {
            this.cryostat = new HashMap<String, Object>();
            this.platform = new HashMap<String, Object>();
        }

        Annotations(Annotations o) {
            this.cryostat = new HashMap<String, Object>(o.cryostat);
            this.platform = new HashMap<String, Object>(o.platform);
        }

        public Map<String, Object> getCryostat() {
            return new HashMap<String, Object>(this.cryostat);
        }

        public Map<String, Object> getPlatform() {
            return new HashMap<String, Object>(this.platform);
        }

        void setCryostat(Map<String, Object> cryostat) {
            this.cryostat = new HashMap<String, Object>(cryostat);
        }

        void setPlatform(Map<String, Object> platform) {
            this.platform = new HashMap<String, Object>(platform);
        }
    }

    public static class Target {
        private String jvmId;
        private URI connectUrl;
        private String alias;
        private Annotations annotations;

        Target() {
        }

        Target(Target o) {
            this.jvmId = o.jvmId;
            this.connectUrl = o.connectUrl;
            this.alias = o.alias;
            this.annotations = new Annotations(o.annotations);
        }

        public Target(String realm, URI connectUrl, String alias, String instanceId, String jvmId, long pid, String hostname, int port, String javaMain, long startTime) {
            this.jvmId = jvmId;
            this.connectUrl = connectUrl;
            this.alias = alias;
            this.annotations = new Annotations();
            this.annotations.setPlatform(Map.of("INSTANCE_ID", instanceId));
            this.annotations.setCryostat(Map.of("REALM", realm, "PID", pid, "HOST", hostname, "PORT", port, "JAVA_MAIN", javaMain, "START_TIME", startTime));
        }

        public String getJvmId() {
            return this.jvmId;
        }

        public URI getConnectUrl() {
            return this.connectUrl;
        }

        public String getAlias() {
            return this.alias;
        }

        public Annotations getAnnotations() {
            return new Annotations(this.annotations);
        }

        void setJvmId(String jvmId) {
            this.jvmId = jvmId;
        }

        void setConnectUrl(URI connectUrl) {
            this.connectUrl = connectUrl;
        }

        void setAlias(String alias) {
            this.alias = alias;
        }

        void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }
    }
}

