/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.insights;

import com.redhat.insights.agent.AgentBasicReport;
import com.redhat.insights.agent.AgentConfiguration;
import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.ClassNoticer;
import com.redhat.insights.agent.InsightsAgentHttpClient;
import com.redhat.insights.agent.shaded.InsightsReportController;
import com.redhat.insights.agent.shaded.http.InsightsHttpClient;
import com.redhat.insights.agent.shaded.jars.JarInfo;
import com.redhat.insights.agent.shaded.tls.PEMSupport;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.cryostat.agent.model.PluginInfo;
import io.cryostat.agent.shaded.ShadeLogger;
import io.cryostat.agent.shaded.org.eclipse.microprofile.config.Config;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;

public class InsightsAgentHelper {
    private static final String INSIGHTS_SVC = "INSIGHTS_SVC";
    static final String RHT_INSIGHTS_JAVA_OPT_OUT = "rht.insights.java.opt-out";
    static final String RHT_INSIGHTS_JAVA_DEBUG = "rht.insights.java.debug";
    private static final BlockingQueue<JarInfo> jarsToSend = new LinkedBlockingQueue<JarInfo>();
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    private final Instrumentation instrumentation;
    private final Config config;

    public InsightsAgentHelper(Config config, Instrumentation instrumentation) {
        this.config = config;
        this.instrumentation = instrumentation;
    }

    public boolean isInsightsEnabled(PluginInfo pluginInfo) {
        boolean optingOut = this.config.getOptionalValue(RHT_INSIGHTS_JAVA_OPT_OUT, Boolean.TYPE).orElse(false);
        return pluginInfo.getEnvAsMap().containsKey(INSIGHTS_SVC) && !optingOut;
    }

    public void runInsightsAgent(PluginInfo pluginInfo) {
        String defaultLogLevel;
        HashMap<String, String> out = new HashMap<String, String>();
        boolean debug = this.config.getOptionalValue(RHT_INSIGHTS_JAVA_DEBUG, Boolean.TYPE).orElse(false);
        if (debug) {
            out.put("debug", "true");
            defaultLogLevel = "debug";
        } else {
            defaultLogLevel = System.getProperty(ShadeLogger.class.getPackageName() + ".org.slf4j.simpleLogger.defaultLogLevel");
        }
        if (defaultLogLevel != null) {
            System.setProperty("com.redhat.insights.agent.shaded.org.slf4j.simpleLogger.defaultLogLevel", defaultLogLevel);
        }
        AgentLogger log = AgentLogger.getLogger();
        log.debug("Starting Red Hat Insights client");
        String server = pluginInfo.getEnvAsMap().get(INSIGHTS_SVC);
        Objects.requireNonNull(server, "Insights server is missing");
        String appName = this.config.getValue("cryostat.agent.app.name", String.class);
        InsightsAgentHelper.instrument(this.instrumentation);
        out.put("name", appName);
        out.put("base_url", server);
        out.put("should_defer", "false");
        out.put("token", "dummy");
        AgentConfiguration config = new AgentConfiguration(out);
        AgentBasicReport simpleReport = AgentBasicReport.of(config);
        PEMSupport pem = new PEMSupport(log, config);
        Supplier<InsightsHttpClient> httpClientSupplier = () -> new InsightsAgentHttpClient(config, () -> pem.createTLSContext());
        InsightsReportController controller = InsightsReportController.of(log, config, simpleReport, httpClientSupplier, jarsToSend);
        controller.generate();
    }

    private static void instrument(Instrumentation instrumentation) {
        ClassNoticer noticer = new ClassNoticer(jarsToSend);
        instrumentation.addTransformer(noticer);
    }
}

