/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import java.util.Objects;

public class TruststoreConfig {
    private final String alias;
    private final String path;
    private final String type;

    private TruststoreConfig(Builder builder) {
        this.alias = Objects.requireNonNull(builder.alias, "Imported certs for the agent's truststore must include a certificate alias");
        this.path = Objects.requireNonNull(builder.path, "Imported certs for the agent's truststore must include a certificate path");
        this.type = Objects.requireNonNull(builder.type, "Imported certs for the agent's truststore must include a certificate type");
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.path, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TruststoreConfig other = (TruststoreConfig)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.path, other.path) && Objects.equals(this.type, other.type);
    }

    public static class Builder {
        private String alias;
        private String path;
        private String type;

        public Builder withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public TruststoreConfig build() {
            return new TruststoreConfig(this);
        }
    }
}

