/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import io.cryostat.agent.AuthorizationType;
import io.cryostat.agent.CallbackResolver;
import io.cryostat.agent.ConfigModule;
import io.cryostat.agent.CryostatClient;
import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.Registration;
import io.cryostat.agent.TruststoreConfig;
import io.cryostat.agent.WebServer;
import io.cryostat.agent.harvest.HarvestModule;
import io.cryostat.agent.remote.RemoteContext;
import io.cryostat.agent.remote.RemoteModule;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.JvmIdentifier;
import io.cryostat.agent.shaded.io.cryostat.libcryostat.net.IDException;
import io.cryostat.agent.shaded.org.apache.shaded.commons.io.IOUtils;
import io.cryostat.agent.shaded.org.apache.shaded.commons.lang3.exception.ExceptionUtils;
import io.cryostat.agent.shaded.org.apache.shaded.http.HttpResponse;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.HttpClient;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.config.RequestConfig;
import io.cryostat.agent.shaded.org.apache.shaded.http.client.protocol.HttpClientContext;
import io.cryostat.agent.shaded.org.apache.shaded.http.config.RegistryBuilder;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.socket.PlainConnectionSocketFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.ssl.NoopHostnameVerifier;
import io.cryostat.agent.shaded.org.apache.shaded.http.conn.ssl.SSLConnectionSocketFactory;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.client.HttpClients;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.client.StandardHttpRequestRetryHandler;
import io.cryostat.agent.shaded.org.apache.shaded.http.impl.conn.BasicHttpClientConnectionManager;
import io.cryostat.agent.shaded.org.apache.shaded.http.protocol.HttpContext;
import io.cryostat.agent.shaded.org.projectnessie.cel.tools.ScriptHost;
import io.cryostat.agent.shaded.org.slf4j.Logger;
import io.cryostat.agent.shaded.org.slf4j.LoggerFactory;
import io.cryostat.agent.triggers.TriggerModule;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@Module(includes={RemoteModule.class, HarvestModule.class, TriggerModule.class, ConfigModule.class})
public abstract class MainModule {
    private static final int NUM_WORKER_THREADS = 3;
    private static final String JVM_ID = "JVM_ID";
    private static final String HTTP_CLIENT_SSL_CTX = "HTTP_CLIENT_SSL_CTX";
    private static final String HTTP_SERVER_SSL_CTX = "HTTP_SERVER_SSL_CTX";

    @Provides
    @Singleton
    public static AtomicInteger provideThreadId() {
        return new AtomicInteger(0);
    }

    @Provides
    @Singleton
    public static ScheduledExecutorService provideExecutor(AtomicInteger threadId) {
        return Executors.newScheduledThreadPool(3, r -> {
            Thread thread = new Thread(r);
            thread.setName("cryostat-agent-worker-" + threadId.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
    }

    @Provides
    @Singleton
    public static ScriptHost provideScriptHost() {
        return ScriptHost.newBuilder().build();
    }

    @Provides
    @Singleton
    public static WebServer provideWebServer(Lazy<Set<RemoteContext>> remoteContexts, Lazy<CryostatClient> cryostat, HttpServer http, @Named(value="cryostat.agent.webserver.credentials.pass.hash-function") MessageDigest digest, @Named(value="cryostat.agent.webserver.credentials.user") String user, @Named(value="cryostat.agent.webserver.credentials.pass.length") int passLength, Lazy<Registration> registration) {
        return new WebServer(remoteContexts, cryostat, http, digest, user, passLength, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<CharBuffer> readPass(Optional<String> pass, Optional<String> passFile, String passFileCharset) throws IOException {
        CharBuffer cb = null;
        if (passFile.isPresent()) {
            byte[] bytes = null;
            try {
                bytes = Files.readAllBytes(Path.of(passFile.get(), new String[0]));
                cb = Charset.forName(passFileCharset).decode(ByteBuffer.wrap(bytes));
                if (bytes == null) return Optional.ofNullable(cb);
            }
            catch (Throwable throwable) {
                if (bytes == null) throw throwable;
                Arrays.fill(bytes, (byte)0);
                throw throwable;
            }
            Arrays.fill(bytes, (byte)0);
            return Optional.ofNullable(cb);
        }
        if (!pass.isPresent()) return Optional.ofNullable(cb);
        cb = CharBuffer.wrap(pass.get().toCharArray());
        return Optional.ofNullable(cb);
    }

    private static void clearBuffer(Optional<CharBuffer> cb) {
        if (cb == null) {
            return;
        }
        cb.ifPresent(c -> Arrays.fill(c.array(), '\u0000'));
        cb.ifPresent(CharBuffer::clear);
    }

    private static byte[] buildPkcs8KeyFromPkcs1Key(byte[] innerKey) {
        byte[] result = new byte[innerKey.length + 26];
        System.arraycopy(Base64.getDecoder().decode("MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKY="), 0, result, 0, 26);
        System.arraycopy(BigInteger.valueOf(result.length - 4).toByteArray(), 0, result, 2, 2);
        System.arraycopy(BigInteger.valueOf(innerKey.length).toByteArray(), 0, result, 24, 2);
        System.arraycopy(innerKey, 0, result, 26, innerKey.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provides
    @Singleton
    @Named(value="HTTP_CLIENT_SSL_CTX")
    public static SSLContext provideClientSslContext(@Named(value="cryostat.agent.webclient.tls.version") String clientTlsVersion, @Named(value="cryostat.agent.webclient.tls.trust-all") boolean trustAll, @Named(value="cryostat.agent.webclient.tls.truststore.path") Optional<String> truststorePath, @Named(value="cryostat.agent.webclient.tls.truststore.pass") Optional<ConfigModule.BytePass> truststorePass, @Named(value="cryostat.agent.webclient.tls.truststore.pass-charset") String passCharset, @Named(value="cryostat.agent.webclient.tls.truststore.type") String truststoreType, @Named(value="cryostat.agent.webclient.tls.truststore.cert") List<TruststoreConfig> truststoreCerts, @Named(value="cryostat.agent.webclient.tls.client-auth.cert.path") Optional<String> clientAuthCertPath, @Named(value="cryostat.agent.webclient.tls.client-auth.cert.type") String clientAuthCertType, @Named(value="cryostat.agent.webclient.tls.client-auth.cert.alias") String clientAuthCertAlias, @Named(value="cryostat.agent.webclient.tls.client-auth.key.path") Optional<String> clientAuthKeyPath, @Named(value="cryostat.agent.webclient.tls.client-auth.key.type") String clientAuthKeyType, @Named(value="cryostat.agent.webclient.tls.client-auth.key.charset") String clientAuthKeyCharset, @Named(value="cryostat.agent.webclient.tls.client-auth.key.encoding") String clientAuthKeyEncoding, @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.type") String clientAuthKeystoreType, @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.pass") Optional<String> clientAuthKeystorePass, @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.pass.file") Optional<String> clientAuthKeystorePassFile, @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.pass-charset") String clientAuthKeystorePassFileCharset, @Named(value="cryostat.agent.webclient.tls.client-auth.key.pass") Optional<String> clientAuthKeyPass, @Named(value="cryostat.agent.webclient.tls.client-auth.key.pass.file") Optional<String> clientAuthKeyPassFile, @Named(value="cryostat.agent.webclient.tls.client-auth.key.pass-charset") String clientAuthKeyPassFileCharset, @Named(value="cryostat.agent.webclient.tls.client-auth.key-manager.type") String clientAuthKeyManagerType, @Named(value="cryostat.agent.baseuri") URI baseUri, @Named(value="cryostat.agent.webclient.tls.required") boolean tlsRequired) {
        try {
            KeyManager[] keyManagers;
            block51: {
                keyManagers = null;
                if (tlsRequired && !baseUri.getScheme().equals("https")) {
                    throw new IllegalArgumentException(String.format("If TLS is enabled via the (%s) property, the base URI (%s) must be an https connection.", "cryostat.agent.webclient.tls.required", "cryostat.agent.baseuri"));
                }
                if (clientAuthCertPath.isPresent() && clientAuthKeyPath.isPresent()) {
                    KeyStore ks = KeyStore.getInstance(clientAuthKeystoreType);
                    Optional<CharBuffer> keystorePass = MainModule.readPass(clientAuthKeystorePass, clientAuthKeystorePassFile, clientAuthKeystorePassFileCharset);
                    Optional<CharBuffer> keyPass = MainModule.readPass(clientAuthKeyPass, clientAuthKeyPassFile, clientAuthKeyPassFileCharset);
                    byte[] keyBytes = new byte[]{};
                    try (BufferedInputStream certIs = new BufferedInputStream(new FileInputStream(Path.of(clientAuthCertPath.get(), new String[0]).toFile()));
                         BufferedInputStream keyIs = new BufferedInputStream(new FileInputStream(Path.of(clientAuthKeyPath.get(), new String[0]).toFile()));){
                        PKCS8EncodedKeySpec keySpec;
                        ks.load(null, keystorePass.map(CharBuffer::array).orElse(null));
                        CertificateFactory certFactory = CertificateFactory.getInstance(clientAuthCertType);
                        Certificate[] certChain = certFactory.generateCertificates(certIs).toArray(new Certificate[0]);
                        KeyFactory keyFactory = KeyFactory.getInstance(clientAuthKeyType);
                        String s = new String(keyIs.readAllBytes(), Charset.forName(clientAuthKeyCharset));
                        String pem = s.replaceAll("-----.+KEY-----", "").replaceAll("\\s+", "");
                        switch (clientAuthKeyEncoding) {
                            case "PKCS1": {
                                keyBytes = MainModule.buildPkcs8KeyFromPkcs1Key(Base64.getDecoder().decode(pem));
                                keySpec = new PKCS8EncodedKeySpec(keyBytes, clientAuthKeyType);
                                break;
                            }
                            case "PKCS8": {
                                keyBytes = Base64.getDecoder().decode(pem);
                                keySpec = new PKCS8EncodedKeySpec(keyBytes, clientAuthKeyType);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unimplemented key encoding: " + clientAuthKeyEncoding);
                            }
                        }
                        PrivateKey key = keyFactory.generatePrivate(keySpec);
                        ks.setKeyEntry(clientAuthCertAlias, key, keyPass.map(CharBuffer::array).orElse(null), certChain);
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(clientAuthKeyManagerType);
                        kmf.init(ks, keystorePass.map(CharBuffer::array).orElse(null));
                        keyManagers = kmf.getKeyManagers();
                        break block51;
                    }
                    finally {
                        Arrays.fill(keyBytes, (byte)0);
                        MainModule.clearBuffer(keystorePass);
                        MainModule.clearBuffer(keyPass);
                    }
                }
                if (clientAuthCertPath.isPresent() || clientAuthKeyPath.isPresent()) {
                    throw new IllegalArgumentException(String.format("To use TLS client authentication, both the certificate (%s) and private key (%s) properties must be set.", "cryostat.agent.webclient.tls.client-auth.cert.path", "cryostat.agent.webclient.tls.client-auth.key.path"));
                }
            }
            X509TrustManager trustManager = null;
            if (trustAll) {
                trustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                };
            } else {
                KeyStore ts;
                X509TrustManager customTrustManager;
                X509TrustManager defaultTrustManager;
                TrustManagerFactory tmf;
                block52: {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init((KeyStore)null);
                    defaultTrustManager = null;
                    customTrustManager = null;
                    for (TrustManager tm : tmf.getTrustManagers()) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        defaultTrustManager = (X509TrustManager)tm;
                        break;
                    }
                    ts = KeyStore.getInstance(truststoreType);
                    ts.load(null, null);
                    if (truststorePath.isPresent() && truststorePass.isPresent()) {
                        Charset charset = Charset.forName(passCharset);
                        CharsetDecoder decoder = charset.newDecoder();
                        ByteBuffer byteBuffer = ByteBuffer.wrap(truststorePass.get().get());
                        CharBuffer charBuffer = decoder.decode(byteBuffer);
                        try (FileInputStream truststore = new FileInputStream(truststorePath.get());){
                            ts.load(truststore, charBuffer.array());
                            break block52;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            Arrays.fill(byteBuffer.array(), (byte)0);
                            Arrays.fill(charBuffer.array(), '\u0000');
                            truststorePass.get().clear();
                        }
                    }
                    if (truststorePath.isPresent() || truststorePass.isPresent()) {
                        throw new IllegalArgumentException(String.format("To import a truststore, provide both the path to the truststore (%s) and the pass (%s), or a path to a file containing the pass (%s)", "cryostat.agent.webclient.tls.truststore.path", "cryostat.agent.webclient.tls.truststore.pass", "cryostat.agent.webclient.tls.truststore.pass.file"));
                    }
                }
                for (TruststoreConfig truststore : truststoreCerts) {
                    try (FileInputStream certFile = new FileInputStream(truststore.getPath());){
                        CertificateFactory cf = CertificateFactory.getInstance(truststore.getType());
                        Certificate cert = cf.generateCertificate(certFile);
                        if (ts.containsAlias(truststore.getType())) {
                            throw new IllegalStateException(String.format("truststore already contains a certificate with alias \"%s\"", truststore.getAlias()));
                        }
                        ts.setCertificateEntry(truststore.getAlias(), cert);
                    }
                    catch (CertificateException e) {
                        throw new RuntimeException(e);
                    }
                }
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ts);
                customTrustManager = null;
                for (TrustManager tm : tmf.getTrustManagers()) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    customTrustManager = (X509TrustManager)tm;
                    break;
                }
                final X509TrustManager finalDefaultTM = defaultTrustManager;
                final X509TrustManager finalCustomTM = customTrustManager;
                trustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        try {
                            finalCustomTM.checkClientTrusted(chain, authType);
                        }
                        catch (CertificateException e) {
                            finalDefaultTM.checkClientTrusted(chain, authType);
                        }
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        try {
                            finalCustomTM.checkServerTrusted(chain, authType);
                        }
                        catch (CertificateException e) {
                            finalDefaultTM.checkServerTrusted(chain, authType);
                        }
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return finalDefaultTM.getAcceptedIssuers();
                    }
                };
            }
            SSLContext sslCtx = SSLContext.getInstance(clientTlsVersion);
            sslCtx.init(keyManagers, new X509TrustManager[]{trustManager}, null);
            return sslCtx;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provides
    @Singleton
    @Named(value="HTTP_SERVER_SSL_CTX")
    public static Optional<SSLContext> provideServerSslContext(@Named(value="cryostat.agent.webserver.tls.version") String serverTlsVersion, @Named(value="cryostat.agent.webserver.tls.keystore.pass") Optional<String> keyStorePassFile, @Named(value="cryostat.agent.webserver.tls.keystore.pass-charset") String passFileCharset, @Named(value="cryostat.agent.webserver.tls.keystore.file") Optional<String> keyStoreFilePath, @Named(value="cryostat.agent.webserver.tls.key.alias") String keyAlias, @Named(value="cryostat.agent.webserver.tls.key.path") Optional<String> keyFilePath, @Named(value="cryostat.agent.webserver.tls.key.pass") Optional<String> keyPass, @Named(value="cryostat.agent.webserver.tls.key.pass.file") Optional<String> keyPassFile, @Named(value="cryostat.agent.webserver.tls.key.pass-charset") String keyPassCharset, @Named(value="cryostat.agent.webserver.tls.key.path") Optional<String> keyPath, @Named(value="cryostat.agent.webserver.tls.key.encoding") String keyEncoding, @Named(value="cryostat.agent.webserver.tls.key.charset") String keyCharset, @Named(value="cryostat.agent.webserver.tls.key.type") String keyType, @Named(value="cryostat.agent.webserver.tls.keystore.type") String keyStoreType, @Named(value="cryostat.agent.webserver.tls.cert.alias") String certAlias, @Named(value="cryostat.agent.webserver.tls.cert.file") Optional<String> certFilePath, @Named(value="cryostat.agent.webserver.tls.cert.type") String certType) {
        boolean ssl;
        boolean bl = ssl = (keyStoreFilePath.isPresent() || keyFilePath.isPresent()) && certFilePath.isPresent();
        if (!ssl) {
            if (keyFilePath.isPresent() || keyStoreFilePath.isPresent() || certFilePath.isPresent()) {
                throw new IllegalArgumentException("The file paths for the keystore or key file, and certificate must ALL be provided to set up HTTPS connections. Otherwise, make sure they are all unset to use an HTTP server.");
            }
            return Optional.empty();
        }
        InputStream keystore = null;
        InputStream pass = null;
        try {
            Optional<SSLContext> optional;
            FileInputStream certFile = new FileInputStream(certFilePath.get());
            try {
                SSLContext sslContext = SSLContext.getInstance(serverTlsVersion);
                if (keyStoreFilePath.isPresent()) {
                    keystore = new FileInputStream(keyStoreFilePath.get());
                }
                char[] storePass = null;
                if (keyStorePassFile.isPresent()) {
                    pass = new FileInputStream(keyStorePassFile.get());
                    String password = IOUtils.toString(pass, Charset.forName(passFileCharset));
                    password = password.substring(0, password.length() - 1);
                    storePass = password.toCharArray();
                }
                KeyStore ks = KeyStore.getInstance(keyStoreType);
                ks.load(keystore, storePass);
                CertificateFactory cf = CertificateFactory.getInstance(certType);
                Certificate cert = cf.generateCertificate(certFile);
                if (ks.containsAlias(certAlias)) {
                    throw new IllegalStateException(String.format("%s keystore at %s already contains a certificate with alias \"%s\"", keyStoreType, keyStoreFilePath, certAlias));
                }
                ks.setCertificateEntry(certAlias, cert);
                if (keyFilePath.isPresent()) {
                    Optional<CharBuffer> kp = MainModule.readPass(keyPass, keyPassFile, keyPassCharset);
                    byte[] keyBytes = new byte[]{};
                    try (BufferedInputStream keyIs = new BufferedInputStream(new FileInputStream(Path.of(keyPath.get(), new String[0]).toFile()));){
                        PKCS8EncodedKeySpec keySpec;
                        KeyFactory keyFactory = KeyFactory.getInstance(keyType);
                        String s = new String(keyIs.readAllBytes(), Charset.forName(keyCharset));
                        String pem = s.replaceAll("-----.+KEY-----", "").replaceAll("\\s+", "");
                        switch (keyEncoding) {
                            case "PKCS1": {
                                keyBytes = MainModule.buildPkcs8KeyFromPkcs1Key(Base64.getDecoder().decode(pem));
                                keySpec = new PKCS8EncodedKeySpec(keyBytes, keyType);
                                break;
                            }
                            case "PKCS8": {
                                keyBytes = Base64.getDecoder().decode(pem);
                                keySpec = new PKCS8EncodedKeySpec(keyBytes, keyType);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unimplemented key encoding: " + keyType);
                            }
                        }
                        PrivateKey key = keyFactory.generatePrivate(keySpec);
                        ks.setKeyEntry(keyAlias, key, kp.map(CharBuffer::array).orElse(null), new Certificate[]{cert});
                    }
                    finally {
                        Arrays.fill(keyBytes, (byte)0);
                        MainModule.clearBuffer(kp);
                    }
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, storePass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                optional = Optional.of(sslContext);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)certFile).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
                    throw new RuntimeException(e);
                }
            }
            ((InputStream)certFile).close();
            return optional;
        }
        finally {
            if (keystore != null) {
                try {
                    keystore.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            if (pass != null) {
                try {
                    pass.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    @Provides
    @Singleton
    public static HttpClient provideHttpClient(final AuthorizationType authorizationType, @Named(value="HTTP_CLIENT_SSL_CTX") SSLContext sslContext, @Named(value="cryostat.agent.webclient.tls.verify-hostname") boolean verifyHostname, @Named(value="cryostat.agent.webclient.connect.timeout-ms") int connectTimeout, @Named(value="cryostat.agent.webclient.response.timeout-ms") int responseTimeout, @Named(value="cryostat.agent.webclient.response.retry-count") int retryCount, @Named(value="cryostat.agent.webclient.tls.required") boolean tlsRequired) {
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, verifyHostname ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE);
        RegistryBuilder<SSLConnectionSocketFactory> socketFactoryRegistryBuilder = RegistryBuilder.create().register("https", sslSocketFactory);
        if (!tlsRequired) {
            socketFactoryRegistryBuilder.register("http", (SSLConnectionSocketFactory)((Object)new PlainConnectionSocketFactory()));
        }
        BasicHttpClientConnectionManager connMan = new BasicHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        return HttpClients.custom().setSSLContext(sslContext).setSSLSocketFactory(sslSocketFactory).setConnectionManager(connMan).setDefaultRequestConfig(RequestConfig.custom().setAuthenticationEnabled(true).setExpectContinueEnabled(true).setConnectTimeout(connectTimeout).setSocketTimeout(responseTimeout).setRedirectsEnabled(true).build()).setRetryHandler(new StandardHttpRequestRetryHandler(retryCount, true){

            @Override
            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                HttpResponse resp;
                HttpClientContext clientCtx;
                if (authorizationType.isDynamic() && (clientCtx = HttpClientContext.adapt(context)).isRequestSent() && (resp = clientCtx.getResponse()) != null && resp.getStatusLine() != null) {
                    int sc = resp.getStatusLine().getStatusCode();
                    if (executionCount < 2 && (sc == 401 || sc == 403)) {
                        return true;
                    }
                }
                return super.retryRequest(exception, executionCount, context);
            }
        }).build();
    }

    @Provides
    @Singleton
    public static HttpServer provideHttpServer(ScheduledExecutorService executor, @Named(value="cryostat.agent.webserver.host") String host, @Named(value="cryostat.agent.webserver.port") int port, @Named(value="HTTP_SERVER_SSL_CTX") Optional<SSLContext> sslContext) {
        try {
            HttpServer http;
            if (sslContext.isEmpty()) {
                http = HttpServer.create(new InetSocketAddress(host, port), 0);
            } else {
                http = HttpsServer.create(new InetSocketAddress(host, port), 0);
                ((HttpsServer)http).setHttpsConfigurator(new HttpsConfigurator(sslContext.get()){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext context = this.getSSLContext();
                            SSLEngine engine = context.createSSLEngine();
                            params.setNeedClientAuth(false);
                            params.setCipherSuites(engine.getEnabledCipherSuites());
                            params.setProtocols(engine.getEnabledProtocols());
                            params.setSSLParameters(context.getDefaultSSLParameters());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            http.setExecutor(executor);
            return http;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Provides
    public static ObjectMapper provideObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Provides
    @Singleton
    public static CryostatClient provideCryostatClient(ScheduledExecutorService executor, ObjectMapper objectMapper, HttpClient http, @Named(value="cryostat.agent.authorization") Supplier<Optional<String>> authorizationSupplier, @Named(value="cryostat.agent.instance-id") String instanceId, @Named(value="JVM_ID") String jvmId, @Named(value="cryostat.agent.app.name") String appName, @Named(value="cryostat.agent.baseuri") URI baseUri, @Named(value="cryostat.agent.realm") String realm) {
        return new CryostatClient(executor, objectMapper, http, authorizationSupplier, instanceId, jvmId, appName, baseUri, realm);
    }

    @Provides
    @Singleton
    public static CallbackResolver provideCallbackResolver(ScriptHost scriptHost, @Named(value="cryostat-agent-callback-candidates") List<ConfigModule.CallbackCandidate> candidates) {
        return new CallbackResolver(scriptHost, candidates);
    }

    @Provides
    @Singleton
    public static Registration provideRegistration(ScheduledExecutorService executor, CryostatClient cryostat, CallbackResolver callbackResolver, WebServer webServer, @Named(value="cryostat.agent.instance-id") String instanceId, @Named(value="JVM_ID") String jvmId, @Named(value="cryostat.agent.app.name") String appName, @Named(value="cryostat.agent.realm") String realm, @Named(value="cryostat.agent.hostname") String hostname, @Named(value="cryostat.agent.app.jmx.port") int jmxPort, @Named(value="cryostat.agent.registration.retry-ms") int registrationRetryMs, @Named(value="cryostat.agent.registration.check-ms") int registrationCheckMs, @Named(value="cryostat.agent.registration.jmx.ignore") boolean registrationJmxIgnore, @Named(value="cryostat.agent.registration.jmx.use-callback-host") boolean registrationJmxUseCallbackHost) {
        Logger log = LoggerFactory.getLogger(Registration.class);
        return new Registration(Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("cryostat-agent-registration");
            t.setUncaughtExceptionHandler((thread, err) -> log.error("[{}] Uncaught exception: {}", (Object)thread.getName(), (Object)ExceptionUtils.getStackTrace(err)));
            return t;
        }), cryostat, callbackResolver, webServer, instanceId, jvmId, appName, realm, hostname, jmxPort, registrationRetryMs, registrationCheckMs, registrationJmxIgnore, registrationJmxUseCallbackHost);
    }

    @Provides
    @Singleton
    public static FlightRecorderHelper provideFlightRecorderHelper() {
        return new FlightRecorderHelper();
    }

    @Provides
    @Singleton
    @Named(value="JVM_ID")
    public static String provideJvmId() {
        try {
            return JvmIdentifier.getLocal().getHash();
        }
        catch (IDException e) {
            throw new RuntimeException(e);
        }
    }
}

