/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import io.cryostat.agent.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.function.Function;

public enum AuthorizationType implements Function<String, String>
{
    NONE(false, v -> null),
    BEARER(false, v -> String.format("Bearer %s", v)),
    BASIC(false, v -> String.format("Basic %s", Base64.getEncoder().encodeToString(v.getBytes(StandardCharsets.UTF_8)))),
    KUBERNETES(true, v -> {
        try {
            File file = new File((String)v);
            String token = Files.readString(file.toPath()).strip();
            return String.format("Bearer %s", token);
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Failed to read serviceaccount token from %s", v), ioe);
        }
    }),
    AUTO(true, v -> {
        try {
            String k8s = AuthorizationType.KUBERNETES.fn.apply((String)v);
            if (StringUtils.isNotBlank(k8s)) {
                return k8s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AuthorizationType.NONE.fn.apply((String)v);
    });

    private final boolean dynamic;
    private final Function<String, String> fn;

    private AuthorizationType(boolean dynamic, Function<String, String> fn) {
        this.dynamic = dynamic;
        this.fn = fn;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public String apply(String in) {
        return this.fn.apply(in);
    }

    public static AuthorizationType fromString(String s) {
        for (AuthorizationType t : AuthorizationType.values()) {
            if (!t.name().toLowerCase().equals(s.toLowerCase())) continue;
            return t;
        }
        return NONE;
    }
}

