/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Factory;
import dagger.internal.Provider;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public final class LazyClassKeyMap<V>
implements Map<Class<?>, V> {
    private final Map<String, V> delegate;

    public static <V> Map<Class<?>, V> of(Map<String, V> delegate) {
        return new LazyClassKeyMap<V>(delegate);
    }

    private LazyClassKeyMap(Map<String, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V get(@Nullable Object key) {
        if (!(key instanceof Class)) {
            throw new IllegalArgumentException("Key must be a class");
        }
        return this.delegate.get(((Class)key).getName());
    }

    @Override
    public Set<Class<?>> keySet() {
        throw new UnsupportedOperationException("Maps created with @LazyClassKey do not support usage of keySet(). Consider @ClassKey instead.");
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (!(key instanceof Class)) {
            throw new IllegalArgumentException("Key must be a class");
        }
        return this.delegate.containsKey(((Class)key).getName());
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        throw new UnsupportedOperationException("Maps created with @LazyClassKey do not support usage of entrySet(). Consider @ClassKey instead.");
    }

    @Override
    public V remove(@Nullable Object key) {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    @Override
    public V put(Class<?> key, V value) {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends V> map) {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    public static class MapProviderFactory<V>
    implements Factory<Map<Class<?>, Provider<V>>> {
        Factory<Map<String, Provider<V>>> delegate;

        public static <V> MapProviderFactory<V> of(Factory<Map<String, Provider<V>>> delegate) {
            return new MapProviderFactory<V>(delegate);
        }

        private MapProviderFactory(Factory<Map<String, Provider<V>>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Map<Class<?>, Provider<V>> get() {
            return LazyClassKeyMap.of((Map)this.delegate.get());
        }
    }

    public static class MapFactory<V>
    implements Factory<Map<Class<?>, V>> {
        Factory<Map<String, V>> delegate;

        public static <V> MapFactory<V> of(Factory<Map<String, V>> delegate) {
            return new MapFactory<V>(delegate);
        }

        private MapFactory(Factory<Map<String, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Map<Class<?>, V> get() {
            return LazyClassKeyMap.of((Map)this.delegate.get());
        }
    }
}

