/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.reports;

import java.util.ArrayList;
import java.util.Map;

public final class Utils {
    private static String REDACTED_VALUE = "=ZZZZZZZZZ";

    private Utils() {
    }

    public static Map<String, Object> defaultMasking(Map<String, Object> inArgs) {
        String jvmArgs = Utils.sanitizeJavaParameters((String)inArgs.getOrDefault("jvm.args", ""));
        inArgs.put("jvm.args", jvmArgs);
        String command = (String)inArgs.getOrDefault("java.command", "");
        inArgs.put("java.command", Utils.sanitizeJavaParameters(command));
        return inArgs;
    }

    static String sanitizeJavaParameters(String parameters) {
        StringBuilder out = new StringBuilder();
        for (String token : Utils.tokenizeComplexJavaParameters(parameters)) {
            if (token.startsWith("-D") && token.contains("=")) {
                String[] parts = token.split("=", 2);
                out.append(parts[0]);
                out.append(REDACTED_VALUE);
                if (token.endsWith(",")) {
                    out.append(',');
                }
                if (token.endsWith("]")) {
                    out.append(']');
                }
            } else {
                out.append(token);
            }
            out.append(" ");
        }
        out.deleteCharAt(out.length() - 1);
        return out.toString();
    }

    static String[] tokenizeComplexJavaParameters(String parameters) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentWord = new StringBuilder();
        Character currentQuote = null;
        boolean escaping = false;
        boolean afterEquals = false;
        for (char c : parameters.toCharArray()) {
            if (c == '\\' && !escaping) {
                escaping = true;
                currentWord.append(c);
                continue;
            }
            if (escaping) {
                escaping = false;
                currentWord.append(c);
                continue;
            }
            if (c == '=') {
                afterEquals = true;
                currentWord.append(c);
                continue;
            }
            if (currentQuote == null && c == ' ') {
                tokens.add(currentWord.toString());
                currentWord = new StringBuilder();
                continue;
            }
            if (c == '\'' || c == '\"') {
                if (currentQuote != null) {
                    if (c == currentQuote.charValue()) {
                        currentQuote = null;
                    }
                } else if (afterEquals || currentWord.length() == 0) {
                    currentQuote = Character.valueOf(c);
                }
            }
            afterEquals = false;
            currentWord.append(c);
        }
        tokens.add(currentWord.toString());
        return tokens.toArray(new String[0]);
    }
}

