/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.reports;

import com.redhat.insights.Filtering;
import com.redhat.insights.config.InsightsConfiguration;
import com.redhat.insights.logging.InsightsLogger;
import com.redhat.insights.reports.InsightsReport;
import com.redhat.insights.reports.InsightsReportSerializer;
import com.redhat.insights.reports.InsightsSubreport;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public abstract class AbstractTopLevelReportBase
implements InsightsReport {
    private static final int BYTES_PER_KB = 1024;
    private static final int BYTES_PER_MB = 0x100000;
    private static final int BYTES_PER_GB = 0x40000000;
    private static final Pattern JSON_WORKAROUND = Pattern.compile("\\\\+$");
    private static final Set<String> allowKeys = Stream.of("http.nonProxyHosts", "java.class.path", "java.class.version", "java.home", "java.library.path", "java.runtime.version", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.version", "java.version", "java.vm.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "jvm.args", "jvm.heap.gc.details", "jvm.heap.max", "jvm.heap.min", "jvm.report_time", "jvm.packages", "jvm.pid", "sun.java.command", "system.arch", "system.cores.logical", "system.hostname", "system.os.name", "system.os.version", "user.dir", "user.name").collect(Collectors.toCollection(HashSet::new));
    private static final Map<String, String> renameKeys;
    private Map<String, Object> options = new HashMap<String, Object>();
    private final Map<String, InsightsSubreport> subReports;
    private final JsonSerializer<InsightsReport> serializer;
    private final InsightsLogger logger;
    private final InsightsConfiguration config;
    private byte @Nullable [] subReport;
    private String idHash = "";

    public AbstractTopLevelReportBase(InsightsLogger logger2, InsightsConfiguration config, Map<String, InsightsSubreport> subReports) {
        this.config = config;
        this.logger = logger2;
        this.subReports = subReports;
        this.serializer = new InsightsReportSerializer();
    }

    @Override
    public void setIdHash(String idHash) {
        this.idHash = idHash;
    }

    @Override
    public String getIdHash() {
        return this.idHash;
    }

    @Override
    public Map<String, InsightsSubreport> getSubreports() {
        return Collections.unmodifiableMap(this.subReports);
    }

    @Override
    public JsonSerializer<InsightsReport> getSerializer() {
        return this.serializer;
    }

    @Override
    public void decorate(String key, String value) {
        this.options.put(key, value);
    }

    @Override
    public void generateReport(Filtering masking) {
        Properties properties = System.getProperties();
        HashMap stringProperties = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (allowKeys.contains(key)) {
                if (renameKeys.containsKey(key)) {
                    stringProperties.put(renameKeys.get(key), v.toString());
                } else {
                    stringProperties.put(key, v.toString());
                }
            }
        }));
        this.options.putAll(stringProperties);
        String name = this.getIdentificationName();
        this.options.put("app.name", name);
        String defaultHost = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            if (host != null) {
                defaultHost = host.getHostName();
            }
        }
        catch (UnknownHostException e) {
            this.logger.error("Unknown Host in lookup, continuing with localhost", e);
        }
        this.options.put("system.hostname", defaultHost);
        OperatingSystemMXBean systemMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.options.put("system.cores.logical", systemMXBean.getAvailableProcessors());
        this.options.put("system.arch", systemMXBean.getArch());
        this.options.put("system.os.version", systemMXBean.getVersion());
        this.options.put("system.os.name", systemMXBean.getName());
        this.options.put("jvm.report_time", System.currentTimeMillis());
        this.options.put("jvm.pid", this.getProcessPID());
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = AbstractTopLevelReportBase.fixInputArguments(runtimeMXBean.getInputArguments());
        this.options.put("jvm.args", String.join((CharSequence)" ", inputArguments));
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        long heapMin = heapMemoryUsage.getInit();
        long heapMax = heapMemoryUsage.getMax();
        for (String arg : inputArguments) {
            if (arg.startsWith("-Xms")) {
                heapMin = AbstractTopLevelReportBase.getMemorySize(arg.substring(4)).orElse(heapMin);
                continue;
            }
            if (!arg.startsWith("-Xmx")) continue;
            heapMax = AbstractTopLevelReportBase.getMemorySize(arg.substring(4)).orElse(heapMax);
        }
        this.options.put("jvm.heap.min", heapMin / 0x100000L);
        this.options.put("jvm.heap.max", heapMax / 0x100000L);
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        StringBuilder gcDetails = new StringBuilder("gc");
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            gcDetails.append("::").append(gcMxBean.getName());
        }
        this.options.put("jvm.heap.gc.details", gcDetails.toString());
        Package[] packages = this.getPackages();
        Object[] out = Arrays.stream(packages).map(Package::toString).toArray();
        this.options.put("jvm.packages", Arrays.toString(out));
        for (InsightsSubreport subReport : this.subReports.values()) {
            subReport.generateReport();
        }
        this.options = masking.apply(this.options);
    }

    protected abstract long getProcessPID();

    protected abstract Package[] getPackages();

    @Override
    public byte[] getSubModulesReport() {
        if (this.subReport == null) {
            this.subReport = InsightsReport.super.getSubModulesReport();
        }
        return this.subReport;
    }

    @Override
    public void close() throws IOException {
        this.subReport = null;
    }

    protected String getIdentificationName() {
        return this.config.getIdentificationName();
    }

    @Override
    public Map<String, Object> getBasic() {
        return Collections.unmodifiableMap(this.options);
    }

    static List<String> fixInputArguments(List<String> args) {
        ArrayList<String> fixed = new ArrayList<String>(args.size());
        for (String arg : args) {
            fixed.add(AbstractTopLevelReportBase.fixString(arg));
        }
        return fixed;
    }

    static String fixString(String arg) {
        Matcher matcher = JSON_WORKAROUND.matcher(arg);
        return matcher.replaceAll("");
    }

    static OptionalLong getMemorySize(String size) {
        if (size == null) {
            return OptionalLong.empty();
        }
        try {
            if (size.endsWith("k") || size.endsWith("K")) {
                return OptionalLong.of(Long.parseLong(size.substring(0, size.length() - 1)) * 1024L);
            }
            if (size.endsWith("m") || size.endsWith("M")) {
                return OptionalLong.of(Long.parseLong(size.substring(0, size.length() - 1)) * 0x100000L);
            }
            if (size.endsWith("g") || size.endsWith("G")) {
                return OptionalLong.of(Long.parseLong(size.substring(0, size.length() - 1)) * 0x40000000L);
            }
            return OptionalLong.of(Long.parseLong(size));
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }

    @Override
    public String getVersion() {
        return "1.0.1";
    }

    static {
        HashMap<String, String> tmpRenames = new HashMap<String, String>();
        tmpRenames.put("http.nonProxyHosts", "jvm.http.nonProxyHosts");
        tmpRenames.put("sun.java.command", "java.command");
        tmpRenames.put("user.dir", "app.user.dir");
        tmpRenames.put("user.name", "app.user.name");
        renameKeys = tmpRenames;
    }
}

