/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.jars;

import com.redhat.insights.jars.JarAnalyzer;
import com.redhat.insights.jars.JarInfo;
import com.redhat.insights.logging.InsightsLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class RecursiveJarAnalyzerHelper {
    private final InsightsLogger logger;

    public RecursiveJarAnalyzerHelper(InsightsLogger logger2) {
        this.logger = logger2;
    }

    public final List<JarInfo> listDeploymentContent(final JarAnalyzer analyzer, final Path tempDir, final String parentName, Path deployment) throws IOException, URISyntaxException {
        final ArrayList<JarInfo> jarInfos = new ArrayList<JarInfo>();
        if (RecursiveJarAnalyzerHelper.isArchive(deployment)) {
            final Path target = RecursiveJarAnalyzerHelper.createTempDirectory(tempDir, "unarchive");
            this.unzip(deployment, target);
            Files.walkFileTree(target, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Files.isRegularFile(file, new LinkOption[0]) && RecursiveJarAnalyzerHelper.isArchive(file)) {
                        try {
                            String path = parentName + '/' + this.formatPath(target.relativize(file));
                            Optional<JarInfo> info = analyzer.process(file.toUri().toURL());
                            if (info.isPresent()) {
                                JarInfo jarInfo = info.get();
                                RecursiveJarAnalyzerHelper.this.logger.debug("Adding the info for " + jarInfo);
                                jarInfo.attributes().put("path", path);
                                jarInfos.add(jarInfo);
                            }
                            if (RecursiveJarAnalyzerHelper.listingRequired(file)) {
                                jarInfos.addAll(RecursiveJarAnalyzerHelper.this.listDeploymentContent(analyzer, tempDir, path, file));
                            }
                        }
                        catch (URISyntaxException ex) {
                            RecursiveJarAnalyzerHelper.this.logger.error("Error reading jar", ex);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                private String formatPath(Path path) {
                    return path.toString().replace(File.separatorChar, '/');
                }
            });
        }
        return jarInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean listingRequired(Path zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            ZipEntry entry;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while ((entry = entries.nextElement()).isDirectory() || !RecursiveJarAnalyzerHelper.isArchive(zipFile.getInputStream(entry)));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static Path createTempDirectory(Path dir, String prefix) throws IOException {
        try {
            return Files.createTempDirectory(dir, prefix, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Files.createTempDirectory(dir, prefix, new FileAttribute[0]);
        }
    }

    public static final boolean isArchive(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            boolean bl;
            ZipFile zip = new ZipFile(path.toFile());
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ZipException e) {
                    return false;
                }
            }
            zip.close();
            return bl;
        }
        return false;
    }

    public static final boolean isArchive(InputStream in) throws IOException {
        if (in != null) {
            boolean bl;
            ZipInputStream zip = new ZipInputStream(in);
            try {
                bl = zip.getNextEntry() != null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ZipException e) {
                    return false;
                }
            }
            zip.close();
            return bl;
        }
        return false;
    }

    public void unzip(Path zip, Path target) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            this.unzip(zipFile, target);
        }
    }

    private void unzip(ZipFile zip, Path targetDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            Path current = this.resolveSecurely(targetDir, name);
            if (entry.isDirectory()) {
                if (!Files.exists(current, new LinkOption[0])) {
                    Files.createDirectories(current, new FileAttribute[0]);
                }
            } else {
                if (Files.notExists(current.getParent(), new LinkOption[0])) {
                    Files.createDirectories(current.getParent(), new FileAttribute[0]);
                }
                try (InputStream eis = zip.getInputStream(entry);){
                    Files.copy(eis, current, new CopyOption[0]);
                }
            }
            try {
                Files.getFileAttributeView(current, BasicFileAttributeView.class, new LinkOption[0]).setTimes(entry.getLastModifiedTime(), entry.getLastAccessTime(), entry.getCreationTime());
            }
            catch (IOException iOException) {}
        }
    }

    public final Path resolveSecurely(Path rootPath, String path) throws IOException {
        Path resolvedPath;
        if (path == null || path.isEmpty()) {
            resolvedPath = rootPath.normalize();
        } else {
            String relativePath = this.removeSuperflousSlashes(path);
            resolvedPath = rootPath.resolve(relativePath).normalize();
        }
        if (!resolvedPath.startsWith(rootPath)) {
            throw new IOException(String.format("Access denied to the content at %s in the deployment", resolvedPath));
        }
        return resolvedPath;
    }

    private String removeSuperflousSlashes(String path) {
        if (path.startsWith("/")) {
            return this.removeSuperflousSlashes(path.substring(1));
        }
        return path;
    }

    public void deleteSilentlyRecursively(Path path) {
        if (path != null) {
            try {
                this.deleteRecursively(path);
            }
            catch (IOException ioex) {
                this.logger.debug(String.format("Error deleting file %s", path), ioex);
            }
        }
    }

    public void deleteRecursively(final Path path) throws IOException {
        this.logger.debug(String.format("Deleting %s recursively", path));
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    RecursiveJarAnalyzerHelper.this.logger.debug(String.format("Error deleting file %s", path), exc);
                    throw exc;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

