/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.jars;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;

public final class JarUtils {
    private static final Map<String, String> EMBEDDED_FORMAT_TO_EXTENSION = JarUtils.getEmbeddedFormatToExtension("ear", "war", "jar");
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String JAR_PROTOCOL = "jar:";
    private static final String BANG_SEPARATOR = "!/";

    private JarUtils() {
    }

    private static Map<String, String> getEmbeddedFormatToExtension(String ... fileExtensions) {
        HashMap<String, String> out = new HashMap<String, String>();
        Stream.of(fileExtensions).forEach(ext -> out.put('.' + ext + BANG_SEPARATOR, (String)ext));
        return out;
    }

    public static InputStream getInputStream(URL url) throws IOException {
        String jarLocation = url.toExternalForm();
        URL jarURL = url;
        for (Map.Entry<String, String> entry : EMBEDDED_FORMAT_TO_EXTENSION.entrySet()) {
            InputStream inputStream;
            JarInputStream jarStream;
            int index = jarLocation.indexOf(entry.getKey());
            if (index <= 0 || index + entry.getKey().length() >= jarLocation.length()) continue;
            String path = url.toExternalForm().substring(index + entry.getKey().length());
            if (path.endsWith(BANG_SEPARATOR)) {
                path = path.substring(0, path.length() - BANG_SEPARATOR.length());
            }
            String jar = jarURL.toExternalForm().substring(0, index + 1 + entry.getValue().length());
            if (jarLocation.startsWith(JAR_PROTOCOL)) {
                jar = jar.substring(JAR_PROTOCOL.length());
            }
            if (!JarUtils.readToEntry(jarStream = new JarInputStream(inputStream = (jarURL = new URL(jar)).openStream()), path)) {
                inputStream.close();
                throw new IOException("Unable to open stream for " + path + " in " + jarURL.toExternalForm());
            }
            return jarStream;
        }
        if (jarLocation.startsWith(JAR_PROTOCOL) && jarLocation.endsWith(BANG_SEPARATOR)) {
            String jarLoc = jarLocation.substring(4, jarLocation.length() - BANG_SEPARATOR.length());
            jarURL = new URL(jarLoc);
        }
        return jarURL.openStream();
    }

    private static boolean readToEntry(JarInputStream jarStream, String path) throws IOException {
        String folderPath = path.endsWith("/") ? path : path + '/';
        JarEntry jarEntry = null;
        while ((jarEntry = jarStream.getNextJarEntry()) != null) {
            if (!path.equals(jarEntry.getName()) && !folderPath.equals(jarEntry.getName())) continue;
            return true;
        }
        return false;
    }

    static JarInputStream getJarInputStream(URL url) throws IOException {
        boolean isEmbedded = JarUtils.isEmbedded(url);
        InputStream is = JarUtils.getInputStream(url);
        if (!isEmbedded && is instanceof JarInputStream) {
            return (JarInputStream)is;
        }
        return new JarInputStream(is);
    }

    private static boolean isEmbedded(URL url) {
        String externalForm = url.toExternalForm();
        for (String prefix : EMBEDDED_FORMAT_TO_EXTENSION.keySet()) {
            if (!externalForm.contains(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String getVersionFromManifest(Manifest manifest) {
        String version = JarUtils.getVersion(manifest.getMainAttributes());
        if (version == null && !manifest.getEntries().isEmpty()) {
            version = JarUtils.getVersion(manifest.getEntries().values().iterator().next());
        }
        return version;
    }

    private static String getVersion(Attributes attributes) {
        String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            version = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            if (version == null) {
                version = attributes.getValue("Bundle-Version");
            }
            if (version == null) {
                version = attributes.getValue("Driver-Version");
            }
        }
        return version;
    }

    public static String computeSha1(URL url) throws NoSuchAlgorithmException, IOException {
        return JarUtils.computeSha(url, "SHA1");
    }

    public static String computeSha256(URL url) throws NoSuchAlgorithmException, IOException {
        return JarUtils.computeSha(url, "SHA-256");
    }

    public static String computeSha512(URL url) throws NoSuchAlgorithmException, IOException {
        return JarUtils.computeSha(url, "SHA-512");
    }

    public static String computeSha256(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        return JarUtils.computeSha(buffer, "SHA-256");
    }

    public static String computeSha512(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        return JarUtils.computeSha(buffer, "SHA-512");
    }

    static String computeSha(URL url, String algorithm) throws NoSuchAlgorithmException, IOException {
        InputStream inputStream = JarUtils.getInputStream(url);
        return JarUtils.computeSha(inputStream, algorithm);
    }

    public static String computeSha(InputStream inputStream, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        int readLen = 128;
        try (DigestInputStream dis = new DigestInputStream(inputStream, md);){
            byte[] readBytes = new byte[128];
            while (dis.read(readBytes) != -1) {
            }
        }
        return JarUtils.toHex(md.digest());
    }

    public static String computeSha(byte[] buffer, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        return JarUtils.toHex(md.digest(buffer));
    }

    private static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String[] computeSha(URL url) throws NoSuchAlgorithmException, IOException {
        try (InputStream inputStream = JarUtils.getInputStream(url);){
            String[] stringArray = JarUtils.computeSha(inputStream);
            return stringArray;
        }
    }

    public static final String[] computeSha(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest mdSha1 = MessageDigest.getInstance("SHA1");
        MessageDigest mdSha256 = MessageDigest.getInstance("SHA-256");
        MessageDigest mdSha512 = MessageDigest.getInstance("SHA-512");
        try (DigestOutputStream outSha1 = new DigestOutputStream(JarUtils.nullOutputStream(), mdSha1);
             DigestOutputStream outSha256 = new DigestOutputStream(JarUtils.nullOutputStream(), mdSha256);
             DigestOutputStream outSha512 = new DigestOutputStream(JarUtils.nullOutputStream(), mdSha512);){
            int nRead;
            byte[] data = new byte[4096];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                outSha1.write(data, 0, nRead);
                outSha256.write(data, 0, nRead);
                outSha512.write(data, 0, nRead);
            }
        }
        return new String[]{JarUtils.toHex(mdSha1.digest()), JarUtils.toHex(mdSha256.digest()), JarUtils.toHex(mdSha512.digest())};
    }

    public static OutputStream nullOutputStream() {
        return new OutputStream(){
            private volatile boolean closed;

            private void ensureOpen() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
            }

            @Override
            public void write(int b) throws IOException {
                this.ensureOpen();
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.ensureOpen();
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }
}

