/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.jars;

import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.jars.JarInfo;
import com.redhat.insights.jars.JarInfoSubreportSerializer;
import com.redhat.insights.logging.InsightsLogger;
import com.redhat.insights.reports.InsightsSubreport;
import io.cryostat.agent.shaded.com.fasterxml.jackson.core.Version;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.cryostat.agent.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class JarInfoSubreport
implements InsightsSubreport {
    protected final InsightsLogger logger;
    protected final Collection<JarInfo> jarInfos;

    public JarInfoSubreport(InsightsLogger logger2) {
        this.logger = logger2;
        this.jarInfos = new ArrayList<JarInfo>();
    }

    public JarInfoSubreport(InsightsLogger logger2, Collection<JarInfo> jarInfos) {
        this.logger = logger2;
        this.jarInfos = jarInfos;
    }

    public Collection<JarInfo> getJarInfos() {
        return Collections.unmodifiableCollection(this.jarInfos);
    }

    @Override
    public void generateReport() {
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public JsonSerializer<InsightsSubreport> getSerializer() {
        return new JarInfoSubreportSerializer();
    }

    public String serializeReport() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null, "com.redhat.insights", "runtimes-java"));
        simpleModule.addSerializer(this.getClass(), this.getSerializer());
        mapper.registerModule(simpleModule);
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (IOException e) {
            throw new InsightsException(InsightsErrorCode.ERROR_SERIALIZING_TO_JSON, "JSON serialization exception", e);
        }
    }
}

