/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.jars;

import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.jars.JarAnalyzer;
import com.redhat.insights.jars.JarInfo;
import com.redhat.insights.jars.JarInfoSubreport;
import com.redhat.insights.logging.InsightsLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;

public class ClasspathJarInfoSubreport
extends JarInfoSubreport {
    private static final String CLASSPATH_ENV = "java.class.path";
    private static final String USER_DIR = "user.dir";

    public ClasspathJarInfoSubreport(InsightsLogger logger2) {
        super(logger2);
    }

    @Override
    public void generateReport() {
        String cpRaw = System.getProperty(CLASSPATH_ENV);
        String[] entries = ClasspathJarInfoSubreport.splitClassPathElements(cpRaw, File.pathSeparator);
        this.jarInfos.clear();
        if (entries.length == 0) {
            this.logger.warning("No classpath entries found");
        } else {
            this.addEntries(entries);
        }
    }

    private void addEntries(String[] entries) {
        JarAnalyzer analyzer = new JarAnalyzer(this.logger, true);
        String cwd = System.getProperty(USER_DIR);
        for (String entry : entries) {
            this.logger.debug(entry);
            try {
                if (!entry.startsWith(File.separator)) {
                    entry = cwd + File.separatorChar + entry;
                }
                URL url = ClasspathJarInfoSubreport.urlFor(entry);
                Optional<JarInfo> oJar = analyzer.process(url);
                oJar.ifPresent(this.jarInfos::add);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new InsightsException(InsightsErrorCode.ERROR_GENERATING_ARCHIVE_HASH, "JAR hashing error", e);
            }
        }
    }

    static String[] splitClassPathElements(String classpath, String separator) {
        return classpath.split(separator);
    }

    static URL urlFor(String entry) throws MalformedURLException {
        return Paths.get(entry, new String[0]).toUri().toURL();
    }
}

